

<?php $__env->startSection('title', 'Al-wasi Soft Tech - COD Courier Management'); ?>

<?php $__env->startSection('content'); ?>
<!-- Hero Section -->
<div class="bg-gradient-to-r from-blue-600 to-blue-800 text-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-20 text-center">
        <div class="inline-block bg-blue-500 bg-opacity-50 px-4 py-1 rounded-full text-sm mb-4">
            End-to-End COD Solution
        </div>
        <h1 class="text-4xl md:text-6xl font-bold mb-6">
            Reliable Cash on Delivery<br>for Your E-Commerce Business
        </h1>
        <p class="text-xl text-blue-100 mb-8 max-w-2xl mx-auto">
            Al-wasi Soft Tech simplifies your logistics with fast, secure, and transparent cash on delivery services. Focus on growing your business; we'll handle the deliveries.
        </p>

        <!-- Track Parcel Form -->
        <form action="<?php echo e(route('parcels.track')); ?>" method="POST" class="max-w-lg mx-auto flex gap-2">
            <?php echo csrf_field(); ?>
            <input type="text" name="tracking_id" placeholder="Enter your tracking ID" 
                   class="flex-1 px-4 py-3 rounded-lg text-gray-900 focus:outline-none focus:ring-2 focus:ring-blue-300"
                   required>
            <button type="submit" class="bg-white text-blue-600 px-6 py-3 rounded-lg font-semibold hover:bg-blue-50 transition">
                Track Parcel
            </button>
        </form>
    </div>
</div>

<!-- Features Section -->
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-20">
    <div class="text-center mb-12">
        <h2 class="text-3xl font-bold text-gray-900 mb-4">Everything You Need to Succeed</h2>
        <p class="text-gray-600 max-w-2xl mx-auto">
            From booking to reconciliation, our platform provides all the tools for a seamless delivery experience.
        </p>
    </div>

    <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
        <div class="bg-white p-6 rounded-xl shadow-sm hover:shadow-md transition">
            <div class="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center mb-4">
                <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"/>
                </svg>
            </div>
            <h3 class="text-lg font-semibold mb-2">Effortless Booking</h3>
            <p class="text-gray-600">Book single or bulk parcels in seconds with our intuitive interface.</p>
        </div>

        <div class="bg-white p-6 rounded-xl shadow-sm hover:shadow-md transition">
            <div class="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center mb-4">
                <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 20l-5.447-2.724A1 1 0 013 16.382V5.618a1 1 0 011.447-.894L9 7m0 13l6-3m-6 3V7m6 10l4.553 2.276A1 1 0 0021 18.382V7.618a1 1 0 00-.553-.894L15 4m0 13V4m0 0L9 7"/>
                </svg>
            </div>
            <h3 class="text-lg font-semibold mb-2">Real-Time Tracking</h3>
            <p class="text-gray-600">Keep your customers informed with live tracking updates from pickup to delivery.</p>
        </div>

        <div class="bg-white p-6 rounded-xl shadow-sm hover:shadow-md transition">
            <div class="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center mb-4">
                <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"/>
                </svg>
            </div>
            <h3 class="text-lg font-semibold mb-2">Automated COD Reconciliation</h3>
            <p class="text-gray-600">Our system automates cash on delivery settlements, ensuring you get paid faster.</p>
        </div>

        <div class="bg-white p-6 rounded-xl shadow-sm hover:shadow-md transition">
            <div class="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center mb-4">
                <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"/>
                </svg>
            </div>
            <h3 class="text-lg font-semibold mb-2">Insightful Analytics</h3>
            <p class="text-gray-600">Access detailed reports on delivery performance, COD collections, and rider efficiency.</p>
        </div>

        <div class="bg-white p-6 rounded-xl shadow-sm hover:shadow-md transition">
            <div class="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center mb-4">
                <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                </svg>
            </div>
            <h3 class="text-lg font-semibold mb-2">Powerful Integrations</h3>
            <p class="text-gray-600">Connect your e-commerce platforms to automate order fulfillment.</p>
        </div>

        <div class="bg-white p-6 rounded-xl shadow-sm hover:shadow-md transition">
            <div class="w-12 h-12 bg-blue-100 rounded-full flex items-center justify-center mb-4">
                <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/>
                </svg>
            </div>
            <h3 class="text-lg font-semibold mb-2">Secure & Reliable</h3>
            <p class="text-gray-600">With role-based access and activity logs, your data and operations are always secure.</p>
        </div>
    </div>
</div>

<!-- How It Works Section -->
<div class="bg-gray-100 py-20">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <h2 class="text-3xl font-bold text-gray-900 mb-4">Get Started in 3 Simple Steps</h2>
            <p class="text-gray-600">Our streamlined process makes courier management a breeze.</p>
        </div>

        <div class="grid md:grid-cols-3 gap-8">
            <div class="text-center">
                <div class="w-16 h-16 bg-blue-600 text-white rounded-full flex items-center justify-center text-2xl font-bold mx-auto mb-4">1</div>
                <h3 class="text-lg font-semibold mb-2">Book Your Parcel</h3>
                <p class="text-gray-600">Create a seller account and book your parcels through our dashboard.</p>
            </div>
            <div class="text-center">
                <div class="w-16 h-16 bg-blue-600 text-white rounded-full flex items-center justify-center text-2xl font-bold mx-auto mb-4">2</div>
                <h3 class="text-lg font-semibold mb-2">We Pick Up & Deliver</h3>
                <p class="text-gray-600">Our rider picks up the parcel and delivers it to your customer, collecting the COD amount.</p>
            </div>
            <div class="text-center">
                <div class="w-16 h-16 bg-blue-600 text-white rounded-full flex items-center justify-center text-2xl font-bold mx-auto mb-4">3</div>
                <h3 class="text-lg font-semibold mb-2">Receive Your Payment</h3>
                <p class="text-gray-600">The collected amount is credited to your wallet, ready for you to request a payout.</p>
            </div>
        </div>
    </div>
</div>

<!-- CTA Section -->
<div class="bg-blue-600 text-white py-16">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h2 class="text-3xl font-bold mb-4">Ready to streamline your deliveries?</h2>
        <p class="text-xl text-blue-100 mb-8">Join hundreds of businesses who trust Al-wasi Soft Tech for their COD logistics.</p>
        <a href="<?php echo e(route('register')); ?>" class="inline-block bg-white text-blue-600 px-8 py-3 rounded-lg font-semibold hover:bg-blue-50 transition">
            Get Started for Free
        </a>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/welcome.blade.php ENDPATH**/ ?>