

<?php $__env->startSection('title', 'Create Compliance Document'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Create Compliance Document</h1>
        <p class="text-xs sm:text-sm text-gray-600 mt-1">Add a new compliance document</p>
    </div>

    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
        <form action="<?php echo e(route('admin.marketing.documents.compliance.store')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Title</label>
                    <input type="text" name="title" value="<?php echo e(old('title')); ?>" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Code</label>
                    <input type="text" name="code" value="<?php echo e(old('code')); ?>" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500" required>
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Category</label>
                    <input type="text" name="category" value="<?php echo e(old('category')); ?>" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Status</label>
                    <select name="status" class="mt-1 w-full border rounded px-3 py-2">
                        <option value="draft">Draft</option>
                        <option value="active">Active</option>
                        <option value="archived">Archived</option>
                    </select>
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Effective Date</label>
                    <input type="date" name="effective_date" value="<?php echo e(old('effective_date')); ?>" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Expires At</label>
                    <input type="date" name="expires_at" value="<?php echo e(old('expires_at')); ?>" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>
                <div class="md:col-span-2">
                    <label class="inline-flex items-center text-sm text-gray-700">
                        <input type="checkbox" name="is_required" value="1" class="mr-2"> Required document
                    </label>
                </div>
                <div class="md:col-span-2">
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Description</label>
                    <textarea name="description" rows="3" class="mt-1 w-full border rounded px-3 py-2"><?php echo e(old('description')); ?></textarea>
                </div>
                <div class="md:col-span-2">
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Content</label>
                    <textarea name="content" rows="8" class="mt-1 w-full border rounded px-3 py-2"><?php echo e(old('content')); ?></textarea>
                </div>
                <div class="md:col-span-2">
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Notes</label>
                    <textarea name="notes" rows="3" class="mt-1 w-full border rounded px-3 py-2"><?php echo e(old('notes')); ?></textarea>
                </div>
            </div>
            <div class="mt-6 flex items-center justify-between">
                <a href="<?php echo e(route('admin.marketing.documents.compliance.index')); ?>" class="text-gray-600 hover:underline">Cancel</a>
                <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Create</button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/admin/marketing/documents/compliance/create.blade.php ENDPATH**/ ?>