

<?php $__env->startSection('title', 'Compliance Documents'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-6 flex items-center justify-between">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Compliance Documents</h1>
            <p class="text-xs sm:text-sm text-gray-600 mt-1">Manage compliance and regulatory documents</p>
        </div>
        <a href="<?php echo e(route('admin.marketing.documents.compliance.create')); ?>" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Create Document</a>
    </div>

    <?php if(session('success')): ?>
        <div class="mb-4 p-3 bg-green-50 border border-green-200 text-green-700 rounded"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Title</th>
                    <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Code</th>
                    <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Category</th>
                    <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Status</th>
                    <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Effective</th>
                    <th class="px-4 py-2 text-right text-[11px] font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php $__empty_1 = true; $__currentLoopData = $documents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td class="px-6 py-4 text-sm text-gray-900"><?php echo e($doc->title); ?></td>
                    <td class="px-6 py-4 text-sm text-gray-600"><?php echo e($doc->code); ?></td>
                    <td class="px-6 py-4 text-sm text-gray-600"><?php echo e($doc->category ?? '-'); ?></td>
                    <td class="px-6 py-4 text-sm">
                        <span class="px-2 py-1 text-xs rounded <?php echo e($doc->status === 'active' ? 'bg-green-100 text-green-700' : ($doc->status === 'draft' ? 'bg-yellow-100 text-yellow-700' : 'bg-gray-100 text-gray-700')); ?>"><?php echo e(ucfirst($doc->status)); ?></span>
                    </td>
                    <td class="px-6 py-4 text-sm text-gray-600"><?php echo e(optional($doc->effective_date)->format('Y-m-d') ?? '-'); ?></td>
                    <td class="px-6 py-4 text-sm text-right">
                        <a href="<?php echo e(route('admin.marketing.documents.compliance.show', $doc)); ?>" class="text-blue-600 hover:underline mr-3">View</a>
                        <a href="<?php echo e(route('admin.marketing.documents.compliance.edit', $doc)); ?>" class="text-indigo-600 hover:underline mr-3">Edit</a>
                        <form action="<?php echo e(route('admin.marketing.documents.compliance.destroy', $doc)); ?>" method="POST" class="inline">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="text-red-600 hover:underline" onclick="return confirm('Delete this document?')">Delete</button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="6" class="px-6 py-4 text-center text-gray-600">No compliance documents found.</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
        <div class="px-6 py-3 border-t"><?php echo e($documents->links()); ?></div>
    </div>
</div>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/admin/marketing/documents/compliance/index.blade.php ENDPATH**/ ?>