

<?php $__env->startSection('title', 'Edit Employee'); ?>

<?php $__env->startSection('content'); ?>
<div class="p-6 lg:p-8">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Edit Employee</h1>
            <p class="text-sm text-gray-600">Update employee details.</p>
        </div>
        <a href="<?php echo e(route('finance.payroll.employee-master')); ?>" class="bg-white text-gray-700 px-4 py-2 rounded-lg border shadow-sm hover:bg-gray-50">Back</a>
    </div>

    <div class="bg-white rounded-lg shadow-md p-6">
        <form action="<?php echo e(route('finance.payroll.employees.update', $employee)); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Full Name</label>
                    <input type="text" name="name" value="<?php echo e($employee->name); ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Email Address</label>
                    <input type="email" name="email" value="<?php echo e($employee->email); ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Phone Number</label>
                    <input type="text" name="phone" value="<?php echo e($employee->phone); ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm">
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Department</label>
                    <input type="text" name="department" value="<?php echo e($employee->department); ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Designation</label>
                    <input type="text" name="designation" value="<?php echo e($employee->designation); ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Joining Date</label>
                    <input type="date" name="date_of_joining" value="<?php echo e($employee->date_of_joining->format('Y-m-d')); ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Salary</label>
                    <input type="number" name="salary" value="<?php echo e($employee->salary); ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" step="0.01" required>
                </div>
                <div>
                    <label class="block text-xs sm:text-sm font-medium text-gray-700">Employee ID</label>
                    <input type="text" name="employee_id" value="<?php echo e($employee->employee_id); ?>" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                </div>
            </div>
            <div class="flex justify-end mt-6">
                <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Update Employee</button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/admin/finance/payroll/edit-employee.blade.php ENDPATH**/ ?>