

<?php $__env->startSection('title', 'Parcel Details - ' . $parcel->tracking_id); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="mb-8">
        <a href="<?php echo e(route(auth()->user()->role === 'seller' ? 'seller.parcels.index' : 'admin.parcels.index')); ?>" 
           class="text-blue-600 hover:text-blue-800 mb-4 inline-block">
            ← Back to Parcels
        </a>
        <h1 class="text-3xl font-bold text-gray-900">Parcel Details</h1>
        <p class="text-gray-600">Tracking ID: <span class="font-semibold"><?php echo e($parcel->tracking_id); ?></span></p>
    </div>

    <!-- Status Badge -->
    <div class="bg-white rounded-lg shadow p-6 mb-6">
        <div class="flex items-center justify-between">
            <div>
                <h2 class="text-lg font-semibold text-gray-900 mb-2">Current Status</h2>
                <span class="px-4 py-2 inline-flex text-sm leading-5 font-semibold rounded-full 
                    <?php if($parcel->status === 'Delivered'): ?> bg-green-100 text-green-800
                    <?php elseif($parcel->status === 'Pending'): ?> bg-yellow-100 text-yellow-800
                    <?php elseif(in_array($parcel->status, ['In Transit', 'Picked Up', 'Out for Delivery'])): ?> bg-blue-100 text-blue-800
                    <?php else: ?> bg-red-100 text-red-800
                    <?php endif; ?>">
                    <?php echo e($parcel->status); ?>

                </span>
            </div>
            <div class="text-right">
                <p class="text-sm text-gray-600">Booking Date</p>
                <p class="text-lg font-semibold"><?php echo e($parcel->booking_date->format('M d, Y')); ?></p>
            </div>
        </div>
    </div>

    <!-- Parcel Information -->
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
        <!-- Customer Information -->
        <div class="bg-white rounded-lg shadow p-6">
            <h2 class="text-lg font-semibold text-gray-900 mb-4">Customer Information</h2>
            <dl class="space-y-3">
                <div>
                    <dt class="text-sm font-medium text-gray-500">Name</dt>
                    <dd class="text-sm text-gray-900"><?php echo e($parcel->recipient_name); ?></dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Contact</dt>
                    <dd class="text-sm text-gray-900"><?php echo e($parcel->contact); ?></dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">City</dt>
                    <dd class="text-sm text-gray-900"><?php echo e($parcel->city); ?></dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Address</dt>
                    <dd class="text-sm text-gray-900"><?php echo e($parcel->address); ?></dd>
                </div>
            </dl>
        </div>

        <!-- Order Information -->
        <div class="bg-white rounded-lg shadow p-6">
            <h2 class="text-lg font-semibold text-gray-900 mb-4">Order Information</h2>
            <dl class="space-y-3">
                <div>
                    <dt class="text-sm font-medium text-gray-500">COD Amount</dt>
                    <dd class="text-sm text-gray-900 font-semibold">PKR <?php echo e(number_format($parcel->cod_amount, 2)); ?></dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Order Reference</dt>
                    <dd class="text-sm text-gray-900"><?php echo e($parcel->order_reference_number ?? 'N/A'); ?></dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Zone</dt>
                    <dd class="text-sm text-gray-900"><?php echo e($parcel->zone); ?></dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Items</dt>
                    <dd class="text-sm text-gray-900"><?php echo e($parcel->items ?? 'N/A'); ?></dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Weight</dt>
                    <dd class="text-sm text-gray-900"><?php echo e($parcel->booking_weight ? $parcel->booking_weight . ' kg' : 'N/A'); ?></dd>
                </div>
            </dl>
        </div>

        <!-- Seller Information -->
        <div class="bg-white rounded-lg shadow p-6">
            <h2 class="text-lg font-semibold text-gray-900 mb-4">Seller Information</h2>
            <dl class="space-y-3">
                <div>
                    <dt class="text-sm font-medium text-gray-500">Name</dt>
                    <dd class="text-sm text-gray-900"><?php echo e($parcel->seller->name); ?></dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Company</dt>
                    <dd class="text-sm text-gray-900"><?php echo e($parcel->seller->company_name); ?></dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Email</dt>
                    <dd class="text-sm text-gray-900"><?php echo e($parcel->seller->email); ?></dd>
                </div>
            </dl>
        </div>

        <!-- Rider Information -->
        <div class="bg-white rounded-lg shadow p-6">
            <h2 class="text-lg font-semibold text-gray-900 mb-4">Rider Information</h2>
            <?php if($parcel->rider): ?>
            <dl class="space-y-3">
                <div>
                    <dt class="text-sm font-medium text-gray-500">Name</dt>
                    <dd class="text-sm text-gray-900"><?php echo e($parcel->rider->name); ?></dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Phone</dt>
                    <dd class="text-sm text-gray-900"><?php echo e($parcel->rider->phone); ?></dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Zone</dt>
                    <dd class="text-sm text-gray-900"><?php echo e($parcel->rider->zone); ?></dd>
                </div>
            </dl>
            <?php else: ?>
            <p class="text-sm text-gray-500">No rider assigned yet</p>
            <?php endif; ?>
        </div>
    </div>

    <!-- Notes -->
    <?php if($parcel->notes): ?>
    <div class="bg-white rounded-lg shadow p-6 mb-6">
        <h2 class="text-lg font-semibold text-gray-900 mb-4">Notes</h2>
        <p class="text-sm text-gray-700"><?php echo e($parcel->notes); ?></p>
    </div>
    <?php endif; ?>

    <!-- Actions -->
    <?php if(auth()->user()->role === 'seller'): ?>
    <div class="bg-white rounded-lg shadow p-6">
        <h2 class="text-lg font-semibold text-gray-900 mb-4">Actions</h2>
        <a href="<?php echo e(route('seller.complaints.create')); ?>?parcel_id=<?php echo e($parcel->id); ?>" 
           class="inline-block bg-red-600 text-white px-6 py-2 rounded-lg hover:bg-red-700">
            Report Issue
        </a>
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/parcels/show.blade.php ENDPATH**/ ?>