

<?php $__env->startSection('title', 'Payments to Merchants'); ?>

<?php $__env->startPush('styles'); ?>
<style>
    body {
        background: #f8f9fa;
        font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
    }
    
    .page-container {
        max-width: 1600px;
        margin: 0 auto;
        padding: 30px 20px;
    }
    
    .breadcrumb-nav {
        font-size: 13px;
        color: #6b7280;
        margin-bottom: 16px;
    }
    
    .breadcrumb-nav a {
        color: #3b82f6;
        text-decoration: none;
    }
    
    .breadcrumb-nav a:hover {
        text-decoration: underline;
    }
    
    .page-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 32px;
    }
    
    .page-title-section h1 {
        font-size: 28px;
        font-weight: 700;
        color: #1a1a1a;
        margin-bottom: 6px;
    }
    
    .page-subtitle {
        font-size: 14px;
        color: #6b7280;
    }
    
    .header-actions {
        display: flex;
        gap: 12px;
        align-items: center;
    }
    
    .btn-primary {
        background: #3b82f6;
        color: white;
        border: none;
        padding: 11px 24px;
        border-radius: 8px;
        font-size: 14px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.2s;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        box-shadow: 0 1px 3px rgba(0,0,0,0.1);
    }
    
    .btn-primary:hover {
        background: #2563eb;
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3);
    }
    
    .btn-secondary {
        background: white;
        color: #374151;
        border: 1px solid #d1d5db;
        padding: 10px 20px;
        border-radius: 8px;
        font-size: 14px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.2s;
    }
    
    .btn-secondary:hover {
        background: #f9fafb;
        border-color: #9ca3af;
    }
    
    .stats-grid {
        display: grid;
        grid-template-columns: repeat(4, 1fr);
        gap: 20px;
        margin-bottom: 30px;
    }
    
    .stat-card {
        background: white;
        border-radius: 16px;
        padding: 24px;
        border: 1px solid #e5e7eb;
        transition: all 0.3s ease;
        position: relative;
        overflow: hidden;
    }
    
    .stat-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        width: 4px;
        height: 100%;
        background: linear-gradient(180deg, #3b82f6, #8b5cf6);
        opacity: 0;
        transition: opacity 0.3s;
    }
    
    .stat-card:hover::before {
        opacity: 1;
    }
    
    .stat-card:hover {
        box-shadow: 0 8px 24px rgba(0,0,0,0.08);
        transform: translateY(-2px);
    }
    
    .stat-label {
        font-size: 13px;
        color: #6b7280;
        margin-bottom: 12px;
        font-weight: 500;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    .stat-value {
        font-size: 32px;
        font-weight: 700;
        color: #1a1a1a;
        margin-bottom: 8px;
    }
    
    .stat-change {
        font-size: 13px;
        color: #10b981;
        margin-top: 8px;
        display: flex;
        align-items: center;
        gap: 4px;
    }
    
    .stat-icon {
        width: 48px;
        height: 48px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 20px;
        margin-bottom: 16px;
    }
    
    .stat-icon.blue {
        background: #eff6ff;
        color: #3b82f6;
    }
    
    .stat-icon.green {
        background: #f0fdf4;
        color: #10b981;
    }
    
    .stat-icon.yellow {
        background: #fffbeb;
        color: #f59e0b;
    }
    
    .stat-icon.purple {
        background: #faf5ff;
        color: #8b5cf6;
    }
    
    .table-card {
        background: white;
        border-radius: 12px;
        border: 1px solid #e5e7eb;
        overflow: hidden;
    }
    
    .table-header {
        padding: 20px;
        border-bottom: 1px solid #e5e7eb;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }
    
    .search-box {
        padding: 8px 16px;
        border: 1px solid #e5e7eb;
        border-radius: 6px;
        width: 300px;
        font-size: 14px;
    }
    
    .data-table {
        width: 100%;
        border-collapse: collapse;
    }
    
    .data-table thead th {
        background: #f9fafb;
        padding: 12px 20px;
        text-align: left;
        font-size: 12px;
        font-weight: 600;
        color: #6b7280;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    .data-table tbody td {
        padding: 16px 20px;
        border-bottom: 1px solid #f3f4f6;
        font-size: 14px;
        color: #1a1a1a;
    }
    
    .data-table tbody tr:hover {
        background: #f9fafb;
    }
    
    .badge {
        padding: 4px 12px;
        border-radius: 12px;
        font-size: 12px;
        font-weight: 600;
    }
    
    .badge-pending {
        background: #fef3c7;
        color: #92400e;
    }
    
    .badge-completed {
        background: #d1fae5;
        color: #065f46;
    }
    
    .badge-failed {
        background: #fee2e2;
        color: #991b1b;
    }
    
    .action-btn {
        background: none;
        border: none;
        color: #3b82f6;
        cursor: pointer;
        padding: 4px 8px;
        font-size: 14px;
        transition: all 0.2s;
    }
    
    .action-btn:hover {
        color: #2563eb;
        text-decoration: underline;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="page-container">
    <!-- Breadcrumb -->
    <div class="breadcrumb-nav">
        <a href="<?php echo e(route('finance.dashboard')); ?>">Dashboard</a> / 
        <a href="#">Finance</a> / 
        <span>Payments to Merchants</span>
    </div>

    <div class="page-header">
        <div class="page-title-section">
            <h1>Payments to Merchants</h1>
            <p class="page-subtitle">Manage and process merchant payments efficiently</p>
        </div>
        <div class="header-actions">
            <button class="btn-secondary">
                <i class="fas fa-download"></i> Export
            </button>
            <button class="btn-secondary">
                <i class="fas fa-filter"></i> Filter
            </button>
<a href="<?php echo e(route('finance.settlements.payments.create')); ?>" class="btn-primary">
                <i class="fas fa-plus"></i> New Payment
            </a>
        </div>
    </div>

    <!-- Stats -->
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon blue">
                <i class="fas fa-clock"></i>
            </div>
            <div class="stat-label">Total Pending</div>
            <div class="stat-value">Rs. <?php echo e(number_format($stats['total_pending'], 2)); ?></div>
            <div class="stat-change">
                <i class="fas fa-arrow-up"></i> <?php echo e($stats['count_pending']); ?> payments
            </div>
        </div>
        <div class="stat-card">
            <div class="stat-icon green">
                <i class="fas fa-check-circle"></i>
            </div>
            <div class="stat-label">Total Completed</div>
            <div class="stat-value">Rs. <?php echo e(number_format($stats['total_completed'], 2)); ?></div>
            <div class="stat-change">
                <i class="fas fa-calendar"></i> This month
            </div>
        </div>
        <div class="stat-card">
            <div class="stat-icon yellow">
                <i class="fas fa-calendar-day"></i>
            </div>
            <div class="stat-label">Today's Payments</div>
            <div class="stat-value">Rs. <?php echo e(number_format($stats['total_today'], 2)); ?></div>
            <div class="stat-change">
                <i class="fas fa-sync"></i> Processed today
            </div>
        </div>
        <div class="stat-card">
            <div class="stat-icon purple">
                <i class="fas fa-hourglass-half"></i>
            </div>
            <div class="stat-label">Pending Count</div>
            <div class="stat-value"><?php echo e($stats['count_pending']); ?></div>
            <div class="stat-change">
                <i class="fas fa-clipboard-list"></i> Awaiting approval
            </div>
        </div>
    </div>

    <!-- Table -->
    <div class="table-card">
        <div class="table-header">
            <div class="flex justify-between items-center">
                <h3 class="text-lg font-semibold">Recent Payments</h3>
<form method="GET" action="<?php echo e(route('finance.settlements.payments.index')); ?>" class="flex items-center space-x-2">
                    <input type="date" name="start_date" class="form-input" value="<?php echo e(request('start_date')); ?>">
                    <input type="date" name="end_date" class="form-input" value="<?php echo e(request('end_date')); ?>">
                    <button type="submit" class="btn-primary">Filter</button>
                </form>
            </div>
        </div>
        
        <table class="data-table">
            <thead>
                <tr>
                    <th>Payment #</th>
                    <th>Merchant</th>
                    <th>Amount</th>
                    <th>Payment Date</th>
                    <th>Method</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><strong><?php echo e($payment->payment_number); ?></strong></td>
                    <td><?php echo e($payment->merchant->name ?? 'N/A'); ?></td>
                    <td><strong>Rs. <?php echo e(number_format($payment->amount, 2)); ?></strong></td>
                    <td><?php echo e($payment->payment_date->format('M d, Y')); ?></td>
                    <td><?php echo e(ucfirst(str_replace('_', ' ', $payment->payment_method))); ?></td>
                    <td>
                        <?php if($payment->status == 'pending'): ?>
                            <span class="badge badge-pending">Pending</span>
                        <?php elseif($payment->status == 'completed'): ?>
                            <span class="badge badge-completed">Completed</span>
                        <?php else: ?>
                            <span class="badge badge-failed"><?php echo e(ucfirst($payment->status)); ?></span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <a href="<?php echo e(route('finance.settlements.payments.show', $payment)); ?>" class="action-btn">View</a>
                        <?php if($payment->status == 'pending'): ?>
<form action="<?php echo e(route('finance.settlements.payments.approve', $payment)); ?>" method="POST" style="display: inline;">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="action-btn" style="color: #10b981;">Approve</button>
                        </form>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="7" style="text-align: center; padding: 40px; color: #9ca3af;">
                        <i class="fas fa-inbox" style="font-size: 48px; margin-bottom: 16px; display: block;"></i>
                        No payments found
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
        
        <?php if($payments->hasPages()): ?>
        <div style="padding: 20px; border-top: 1px solid #e5e7eb;">
            <?php echo e($payments->links()); ?>

        </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/admin/finance/settlements/payments/index.blade.php ENDPATH**/ ?>