

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-xl font-semibold">Span Management</h1>
        <a href="<?php echo e(route('admin.spans.create')); ?>" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Add Span</a>
    </div>

    <?php if(session('success')): ?>
        <div class="mb-4 p-3 bg-green-100 text-green-700 rounded"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <div class="bg-white rounded-lg shadow p-4 mb-4">
        <form method="GET" action="<?php echo e(route('admin.spans.index')); ?>" class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <input type="text" name="q" value="<?php echo e($q); ?>" placeholder="Search name/code/category/owner" class="border rounded p-2" />
            <select name="status" class="border rounded p-2">
                <option value="">All Status</option>
                <option value="active" <?php echo e($status==='active'?'selected':''); ?>>Active</option>
                <option value="inactive" <?php echo e($status==='inactive'?'selected':''); ?>>Inactive</option>
                <option value="archived" <?php echo e($status==='archived'?'selected':''); ?>>Archived</option>
            </select>
            <button class="px-4 py-2 bg-indigo-600 text-white rounded">Filter</button>
            <a href="<?php echo e(route('admin.spans.index')); ?>" class="px-4 py-2 bg-gray-200 text-gray-800 rounded">Reset</a>
        </form>
    </div>

    <div class="bg-white rounded-lg shadow overflow-hidden">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
            <tr>
                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500">Name</th>
                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500">Code</th>
                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500">Category</th>
                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500">Owner</th>
                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500">Status</th>
                <th class="px-4 py-2 text-left text-xs font-medium text-gray-500">Period</th>
                <th class="px-4 py-2 text-right text-xs font-medium text-gray-500">Actions</th>
            </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
            <?php $__empty_1 = true; $__currentLoopData = $spans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $span): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td class="px-4 py-2"><?php echo e($span->name); ?></td>
                    <td class="px-4 py-2"><?php echo e($span->code); ?></td>
                    <td class="px-4 py-2"><?php echo e($span->category ?? '-'); ?></td>
                    <td class="px-4 py-2"><?php echo e($span->owner ?? '-'); ?></td>
                    <td class="px-4 py-2">
                        <span class="px-2 py-1 rounded text-xs <?php echo e($span->status==='active'?'bg-green-100 text-green-700':($span->status==='inactive'?'bg-yellow-100 text-yellow-700':'bg-gray-100 text-gray-700')); ?>"><?php echo e(ucfirst($span->status)); ?></span>
                    </td>
                    <td class="px-4 py-2 text-sm"><?php echo e(optional($span->start_date)->format('Y-m-d')); ?> — <?php echo e(optional($span->end_date)->format('Y-m-d')); ?></td>
                    <td class="px-4 py-2 text-right">
                        <a href="<?php echo e(route('admin.spans.show', $span)); ?>" class="text-blue-600 hover:text-blue-900 mr-2">View</a>
                        <a href="<?php echo e(route('admin.spans.edit', $span)); ?>" class="text-green-600 hover:text-green-900 mr-2">Edit</a>
                        <form action="<?php echo e(route('admin.spans.destroy', $span)); ?>" method="POST" class="inline" onsubmit="return confirm('Delete span?')">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button class="text-red-600 hover:text-red-900">Delete</button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr><td colspan="7" class="text-center py-10 text-gray-500">No spans found.</td></tr>
            <?php endif; ?>
            </tbody>
        </table>
        <div class="p-4"><?php echo e($spans->links()); ?></div>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/admin/spans/index.blade.php ENDPATH**/ ?>