<?php $__env->startSection('title', 'Branch Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Branch Dashboard</h1>
        <p class="text-xs sm:text-sm text-gray-600 mt-1">Overview of all operations for your branch today</p>
    </div>

    <!-- Stats Grid -->
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 mb-6">
        <div class="bg-white p-4 rounded-lg shadow-sm flex items-start justify-between">
            <div>
                <p class="text-sm text-gray-600">Assigned Shipments</p>
                <p class="text-2xl font-bold text-gray-900"><?php echo e($assignedShipments); ?></p>
                <p class="text-xs text-gray-500">Shipments assigned to riders today</p>
            </div>
            <i class="fas fa-truck text-2xl text-gray-300"></i>
        </div>
        <div class="bg-white p-4 rounded-lg shadow-sm flex items-start justify-between">
            <div>
                <p class="text-sm text-gray-600">Delivered</p>
                <p class="text-2xl font-bold text-gray-900"><?php echo e($deliveredParcels); ?></p>
                <p class="text-xs text-gray-500">Successfully delivered shipments</p>
            </div>
            <i class="fas fa-check-circle text-2xl text-green-400"></i>
        </div>
        <div class="bg-white p-4 rounded-lg shadow-sm flex items-start justify-between">
            <div>
                <p class="text-sm text-gray-600">Failed</p>
                <p class="text-2xl font-bold text-gray-900"><?php echo e($failedDeliveries); ?></p>
                <p class="text-xs text-gray-500">Failed delivery attempts</p>
            </div>
            <i class="fas fa-exclamation-circle text-2xl text-red-400"></i>
        </div>
        <div class="bg-white p-4 rounded-lg shadow-sm flex items-start justify-between">
            <div>
                <p class="text-sm text-gray-600">Return (RTO)</p>
                <p class="text-2xl font-bold text-gray-900"><?php echo e($returnShipments); ?></p>
                <p class="text-xs text-gray-500">Shipments marked for return</p>
            </div>
            <i class="fas fa-undo text-2xl text-gray-300"></i>
        </div>
        <div class="bg-white p-4 rounded-lg shadow-sm flex items-start justify-between">
            <div>
                <p class="text-sm text-gray-600">COD Collected vs Deposited</p>
                <p class="text-2xl font-bold text-gray-900"><?php echo e(number_format($codCollected, 0)); ?> / <?php echo e(number_format($codDeposited, 0)); ?></p>
                <p class="text-xs text-gray-500">PKR Collected / Deposited</p>
            </div>
            <i class="fas fa-coins text-2xl text-yellow-400"></i>
        </div>
        <div class="bg-white p-4 rounded-lg shadow-sm flex items-start justify-between">
            <div>
                <p class="text-sm text-gray-600">Move to Origin</p>
                <p class="text-2xl font-bold text-gray-900"><?php echo e($moveToOrigin); ?></p>
                <p class="text-xs text-gray-500">Parcels to be moved to origin hub</p>
            </div>
            <i class="fas fa-shipping-fast text-2xl text-gray-300"></i>
        </div>
        <div class="bg-white p-4 rounded-lg shadow-sm flex items-start justify-between">
            <div>
                <p class="text-sm text-gray-600">Received</p>
                <p class="text-2xl font-bold text-gray-900"><?php echo e($received); ?></p>
                <p class="text-xs text-gray-500">Parcels received at the branch</p>
            </div>
            <i class="fas fa-download text-2xl text-gray-300"></i>
        </div>
        <div class="bg-white p-4 rounded-lg shadow-sm flex items-start justify-between">
            <div>
                <p class="text-sm text-gray-600">Bags Received</p>
                <p class="text-2xl font-bold text-gray-900"><?php echo e($bagsReceived); ?></p>
                <p class="text-xs text-gray-500">Incoming bags</p>
            </div>
            <i class="fas fa-shopping-bag text-2xl text-gray-300"></i>
        </div>
        <div class="bg-white p-4 rounded-lg shadow-sm flex items-start justify-between">
            <div>
                <p class="text-sm text-gray-600">Un-Bagging</p>
                <p class="text-2xl font-bold text-gray-900"><?php echo e($unbagging); ?></p>
                <p class="text-xs text-gray-500">Bags to be un-scanned</p>
            </div>
            <i class="fas fa-box-open text-2xl text-gray-300"></i>
        </div>
        <div class="bg-white p-4 rounded-lg shadow-sm flex items-start justify-between">
            <div>
                <p class="text-sm text-gray-600">Pickup Orders</p>
                <p class="text-2xl font-bold text-gray-900"><?php echo e($pickupOrders); ?></p>
                <p class="text-xs text-gray-500">Pending pickup assignments</p>
            </div>
            <i class="fas fa-hand-holding-usd text-2xl text-gray-300"></i>
        </div>
        <div class="bg-white p-4 rounded-lg shadow-sm flex items-start justify-between">
            <div>
                <p class="text-sm text-gray-600">Pending Orders</p>
                <p class="text-2xl font-bold text-gray-900"><?php echo e($pendingOrders); ?></p>
                <p class="text-xs text-gray-500">Orders waiting for assignment</p>
            </div>
            <i class="fas fa-hourglass-half text-2xl text-gray-300"></i>
        </div>
        <div class="bg-white p-4 rounded-lg shadow-sm flex items-start justify-between">
            <div>
                <p class="text-sm text-gray-600">Reattempt Pending</p>
                <p class="text-2xl font-bold text-gray-900"><?php echo e($reattemptPending); ?></p>
                <p class="text-xs text-gray-500">Shipments pending reattempt</p>
            </div>
            <i class="fas fa-redo text-2xl text-gray-300"></i>
        </div>
        <div class="bg-white p-4 rounded-lg shadow-sm flex items-start justify-between">
            <div>
                <p class="text-sm text-gray-600">Amount Pending to Deposit</p>
                <p class="text-2xl font-bold text-gray-900">PKR <?php echo e(number_format($amountPendingToDeposit, 0)); ?></p>
                <p class="text-xs text-gray-500">COD variance</p>
            </div>
            <i class="fas fa-money-bill-wave text-2xl text-gray-300"></i>
        </div>
        <div class="bg-white p-4 rounded-lg shadow-sm flex items-start justify-between">
            <div>
                <p class="text-sm text-gray-600">Complaints</p>
                <p class="text-2xl font-bold text-gray-900"><?php echo e($complaints); ?></p>
                <p class="text-xs text-gray-500">Active branch complaints</p>
            </div>
            <i class="fas fa-comment-dots text-2xl text-gray-300"></i>
        </div>
        <div class="bg-white p-4 rounded-lg shadow-sm flex items-start justify-between">
            <div>
                <p class="text-sm text-gray-600">Internal Updates</p>
                <p class="text-2xl font-bold text-gray-900"><?php echo e($internalUpdates); ?></p>
                <p class="text-xs text-gray-500">New notifications for branch</p>
            </div>
            <i class="fas fa-bell text-2xl text-gray-300"></i>
        </div>
    </div>

    <!-- Recent Parcels -->
    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <div class="px-3 sm:px-4 lg:px-6 py-3 sm:py-4 border-b border-gray-200">
            <h2 class="text-base sm:text-lg font-bold text-gray-900">Recent Parcels</h2>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Tracking ID</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Recipient</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Rider</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">COD Amount</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Status</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__empty_1 = true; $__currentLoopData = $recentParcels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parcel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs font-medium text-blue-600"><?php echo e($parcel->tracking_id); ?></td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-900"><?php echo e($parcel->recipient_name); ?></td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-900"><?php echo e($parcel->rider->name ?? 'Unassigned'); ?></td>
                        <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-900">PKR <?php echo e(number_format($parcel->cod_amount, 2)); ?></td>
                        <td class="px-4 py-2.5 whitespace-nowrap">
                            <span class="px-2 inline-flex text-[10px] leading-4 font-semibold rounded-full 
                                <?php if($parcel->status === 'Delivered'): ?> bg-green-100 text-green-800
                                <?php elseif($parcel->status === 'Pending'): ?> bg-yellow-100 text-yellow-800
                                <?php elseif(in_array($parcel->status, ['In Transit', 'Picked Up'])): ?> bg-blue-100 text-blue-800
                                <?php else: ?> bg-red-100 text-red-800
                                <?php endif; ?>">
                                <?php echo e($parcel->status); ?>

                            </span>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="5" class="px-4 py-3 text-center text-xs text-gray-500">No parcels found</td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/branch/dashboard.blade.php ENDPATH**/ ?>