

<?php $__env->startSection('title', 'Bank Reconciliation'); ?>

<?php $__env->startSection('content'); ?>
<div class="p-6 lg:p-8" x-data="{ showModal: false }" @open-modal.window="showModal = true">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Bank Reconciliation</h1>
            <p class="text-sm text-gray-600">Import bank statements and reconcile transactions.</p>
        </div>
        <button @click="showModal = true" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Upload Statement</button>
    </div>

    <!-- Statements Table -->
    <div class="bg-white rounded-lg shadow-md">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Bank</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Period</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Uploaded</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__empty_1 = true; $__currentLoopData = $recons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td class="px-6 py-4"><?php echo e($rec->bank_name); ?></td>
                            <td class="px-6 py-4"><?php echo e($rec->statement_period); ?></td>
                            <td class="px-6 py-4"><?php echo e($rec->uploaded_at->format('M d, Y')); ?></td>
                            <td class="px-6 py-4 text-right">
                                <a href="<?php echo e(url('finance/banking.reconciliation.show', $rec)); ?>" class="text-indigo-600 hover:text-indigo-900">Open</a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr><td colspan="4" class="text-center py-10 text-gray-500">No statements imported yet.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <div class="p-4"><?php echo e($recons->links()); ?></div>
    </div>

    <!-- Upload Modal -->
    <div x-show="showModal" @click.away="showModal = false" class="fixed inset-0 bg-gray-600 bg-opacity-50 h-full w-full z-50" x-cloak>
        <div class="relative top-10 mx-auto p-5 border w-full max-w-lg shadow-lg rounded-md bg-white">
            <form action="<?php echo e(url('finance/banking.reconciliation.store')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <h3 class="text-lg font-semibold mb-4">Upload Bank Statement (CSV)</h3>
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm">Bank Name</label>
                        <input type="text" name="bank_name" class="form-input" required>
                    </div>
                    <div>
                        <label class="block text-sm">Statement Period</label>
                        <input type="month" name="period" class="form-input" value="<?php echo e(date('Y-m')); ?>" required>
                    </div>
                    <div>
                        <label class="block text-sm">CSV File</label>
                        <input type="file" name="statement" accept=".csv,text/csv" class="form-input" required>
                        <p class="text-xs text-gray-500 mt-1">Expected headers: date, description, amount</p>
                    </div>
                </div>
                <div class="flex justify-end space-x-2 mt-6">
                    <button type="button" @click="showModal = false" class="bg-gray-300 text-gray-700 px-4 py-2 rounded-lg">Close</button>
                    <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Import</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        <?php if($errors->any()): ?>
            window.dispatchEvent(new CustomEvent('open-modal'));
        <?php endif; ?>
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/admin/finance/banking/reconciliation.blade.php ENDPATH**/ ?>