

<?php $__env->startSection('title', 'Journal Entries'); ?>

<?php $__env->startSection('content'); ?>
<div class="p-6 lg:p-8" x-data="{ showModal: false }" @open-modal.window="showModal = true" x-init="() => { if ($el.querySelector('#error-block')) showModal = true }">
    <!-- Page Header -->
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Journal Entries</h1>
            <p class="text-sm text-gray-600">Record and manage all manual journal entries.</p>
        </div>
        <div>
            <button @click="showModal = true" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">New Journal Entry</button>
        </div>
    </div>

    <!-- Journal Entries Table -->
    <div class="bg-white rounded-lg shadow-md">
        <div class="p-4 border-b flex justify-between items-center">
            <h3 class="text-lg font-semibold">All Journal Entries</h3>
            <form method="GET" action="<?php echo e(route('admin.finance.accounting.journal-entries')); ?>" class="flex items-center space-x-2">
                <input type="date" name="start_date" class="form-input" value="<?php echo e(request('start_date')); ?>">
                <input type="date" name="end_date" class="form-input" value="<?php echo e(request('end_date')); ?>">
                <button type="submit" class="btn-primary">Filter</button>
            </form>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Date</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Entry #</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Description</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Total Debit</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Total Credit</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__empty_1 = true; $__currentLoopData = $journalEntries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-500"><?php echo e($entry->entry_date->format('M d, Y')); ?></td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs font-medium text-gray-900"><?php echo e($entry->entry_number); ?></td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-500"><?php echo e(\Illuminate\Support\Str::limit($entry->description, 50)); ?></td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-500">Rs. <?php echo e(number_format($entry->total_debit, 2)); ?></td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-500">Rs. <?php echo e(number_format($entry->total_credit, 2)); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="px-2 inline-flex text-[10px] leading-4 font-semibold rounded-full bg-blue-100 text-blue-800"><?php echo e(ucfirst($entry->status)); ?></span>
                            </td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs font-medium">
                                <a href="#" class="text-indigo-600 hover:text-indigo-900">View</a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="text-center py-10 text-gray-500">No journal entries found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>


<?php if($errors->any()): ?>
<div id="error-block" class="bg-red-50 border border-red-200 text-red-700 px-4 py-3 rounded mb-4">
    <ul class="list-disc ml-4 text-sm">
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($e); ?></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
</div>
<?php endif; ?>

<!-- Add Journal Entry Modal -->
<div x-show="showModal" @click.away="showModal = false" class="fixed inset-0 bg-gray-600 bg-opacity-50 h-full w-full z-50" x-cloak>
    <div class="relative top-10 mx-auto p-5 border w-full max-w-4xl shadow-lg rounded-md bg-white">
        <div class="flex justify-between items-center mb-4">
            <h3 class="text-lg font-semibold">New Journal Entry</h3>
            <button @click="showModal = false" class="text-gray-400 hover:text-gray-500">&times;</button>
        </div>
        <form action="<?php echo e(route('admin.finance.accounting.journal-entries.store')); ?>" method="POST" id="journalEntryForm">
            <?php echo csrf_field(); ?>
            <div>
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-4">
                        <div>
                            <label class="block text-xs sm:text-sm font-medium text-gray-700">Entry Date</label>
                            <input type="date" name="entry_date" class="mt-1 form-input" value="<?php echo e(old('entry_date', date('Y-m-d'))); ?>" required>
                        </div>
                        <div class="md:col-span-2">
                            <label class="block text-xs sm:text-sm font-medium text-gray-700">Description</label>
                            <input type="text" name="description" class="mt-1 form-input" placeholder="e.g., Monthly office rent" value="<?php echo e(old('description')); ?>" required>
                        </div>
                    </div>

                    <h6 class="text-lg font-semibold mt-6 mb-2">Entry Lines</h6>
                    <div id="entry-lines-container" class="space-y-2"></div>
                    <button type="button" id="add-line-btn" class="bg-white border border-gray-300 text-gray-700 px-3 py-2 rounded-md hover:bg-gray-50 mt-2">Add Line</button>

                    <div class="flex justify-end mt-4 space-x-4 font-semibold">
                        <div>Total Debit: <span id="total-debit">Rs. 0.00</span></div>
                        <div>Total Credit: <span id="total-credit">Rs. 0.00</span></div>
                    </div>
                </div>
                <div class="flex justify-end space-x-2 mt-6">
                    <button type="button" @click="showModal = false" class="bg-gray-300 text-gray-700 px-4 py-2 rounded-lg hover:bg-gray-400">Close</button>
                    <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Save Entry</button>
                </div>
            </form>
        </div>
    </div>
</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        <?php if($errors->any()): ?>
            window.dispatchEvent(new CustomEvent('open-modal'));
        <?php endif; ?>
    });
</script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    let lineIndex = 0;
    const container = document.getElementById('entry-lines-container');

    function addLine() {
        const index = lineIndex++;
        const row = document.createElement('div');
        row.className = 'grid grid-cols-12 gap-2 items-center';
        row.innerHTML = `
            <div class="col-span-5"><select name="lines[${index}][account_id]" class="form-select" required><option value="">Select Account</option><?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><option value="<?php echo e($account->id); ?>"><?php echo e($account->account_code); ?> - <?php echo e($account->account_name); ?></option><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></select></div>
            <div class="col-span-3"><select name="lines[${index}][type]" class="form-select line-type" required><option value="debit">Debit</option><option value="credit">Credit</option></select></div>
            <div class="col-span-3"><input type="number" name="lines[${index}][amount]" class="form-input line-amount" placeholder="Amount" step="0.01" required></div>
            <div class="col-span-1"><button type="button" class="text-red-500 hover:text-red-700 remove-line-btn"><i class="fas fa-trash"></i></button></div>
        `;
        container.appendChild(row);
    }

    document.getElementById('add-line-btn').addEventListener('click', addLine);

    container.addEventListener('click', function(e) {
        if (e.target.closest('.remove-line-btn')) {
            e.target.closest('.grid').remove();
            calculateTotals();
        }
    });

    container.addEventListener('input', function(e) {
        if (e.target.classList.contains('line-amount') || e.target.classList.contains('line-type')) {
            calculateTotals();
        }
    });

    function calculateTotals() {
        let totalDebit = 0;
        let totalCredit = 0;
        document.querySelectorAll('#entry-lines-container .grid').forEach(row => {
            const type = row.querySelector('.line-type').value;
            const amount = parseFloat(row.querySelector('.line-amount').value) || 0;
            if (type === 'debit') totalDebit += amount; else totalCredit += amount;
        });
        document.getElementById('total-debit').textContent = 'Rs. ' + totalDebit.toFixed(2);
        document.getElementById('total-credit').textContent = 'Rs. ' + totalCredit.toFixed(2);
    }

    addLine();
    addLine();
});
</script>
<?php $__env->stopPush(); ?>




<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/admin/finance/accounting/journal-entries.blade.php ENDPATH**/ ?>