

<?php $__env->startSection('title', 'Tax Filings'); ?>

<?php $__env->startSection('content'); ?>
<div class="p-6 lg:p-8" x-data="{ showModal: false }" @open-modal.window="showModal = true">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Tax Filings</h1>
            <p class="text-sm text-gray-600">Track and manage all tax filings.</p>
        </div>
        <button @click="showModal = true" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Add New Filing</button>
    </div>

    <!-- Filters -->
    <form method="GET" action="<?php echo e(url('finance/taxation.filings')); ?>" class="bg-white rounded-lg shadow-md p-4 mb-6 grid grid-cols-1 md:grid-cols-3 gap-4">
        <input type="month" name="period" value="<?php echo e(request('period')); ?>" class="form-input">
        <select name="status" class="form-select">
            <option value="">All Statuses</option>
            <?php $__currentLoopData = ['pending', 'filed', 'overdue']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($status); ?>" <?php echo e(request('status') == $status ? 'selected' : ''); ?>><?php echo e(ucfirst($status)); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
        <button type="submit" class="bg-gray-800 text-white px-4 py-2 rounded-md">Filter</button>
    </form>

    <!-- Filings Table -->
    <div class="bg-white rounded-lg shadow-md">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Type</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Period</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Due Date</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Filed On</th>
                        <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase">Status</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__empty_1 = true; $__currentLoopData = $filings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $filing): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td class="px-6 py-4"><?php echo e($filing->filing_type); ?></td>
                            <td class="px-6 py-4"><?php echo e($filing->period); ?></td>
                            <td class="px-6 py-4"><?php echo e($filing->due_date->format('M d, Y')); ?></td>
                            <td class="px-6 py-4"><?php echo e($filing->filed_on ? $filing->filed_on->format('M d, Y') : '-'); ?></td>
                            <td class="px-6 py-4 text-center"><span class="px-2 py-1 text-xs rounded-full bg-gray-200"><?php echo e(ucfirst($filing->status)); ?></span></td>
                            <td class="px-6 py-4 text-right"><a href="#" class="text-indigo-600">Edit</a></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr><td colspan="6" class="text-center py-10">No tax filings found.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Add Filing Modal -->
    <div x-show="showModal" @click.away="showModal = false" class="fixed inset-0 bg-gray-600 bg-opacity-50 h-full w-full z-50" x-cloak>
        <div class="relative top-10 mx-auto p-5 border w-full max-w-lg shadow-lg rounded-md bg-white">
            <form action="<?php echo e(url('finance/taxation.filings.submit')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <h3 class="text-lg font-semibold mb-4">Add New Tax Filing</h3>
                <div class="space-y-4">
                                        <div>
                        <label class="block text-sm">Filing Type</label>
                        <input type="text" name="filing_type" class="form-input" placeholder="e.g., GSTR-1" required>
                    </div>
                    <div>
                        <label class="block text-sm">Period</label>
                        <input type="month" name="period" class="form-input" value="<?php echo e(date('Y-m')); ?>" required>
                    </div>
                    <div>
                        <label class="block text-sm">Due Date</label>
                        <input type="date" name="due_date" class="form-input" required>
                    </div>
                    <div>
                        <label class="block text-sm">Tax Amount (Optional)</label>
                        <input type="number" name="tax_amount" step="0.01" class="form-input">
                    </div>
                    <div>
                        <label class="block text-sm">Document (Optional)</label>
                        <input type="file" name="document_path" class="form-input">
                    </div>
                </div>
                <div class="flex justify-end space-x-2 mt-6">
                    <button type="button" @click="showModal = false" class="bg-gray-300 text-gray-700 px-4 py-2 rounded-lg">Close</button>
                    <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Save Filing</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        <?php if($errors->any()): ?>
            window.dispatchEvent(new CustomEvent('open-modal'));
        <?php endif; ?>
    });
</script>
<?php $__env->stopPush(); ?>




<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/admin/finance/taxation/filings.blade.php ENDPATH**/ ?>