

<?php $__env->startSection('title', 'Bulk Order Upload'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-6">
    <h1 class="text-2xl font-semibold text-gray-800 mb-6">Bulk Order Upload</h1>

    <form action="<?php echo e(route('seller.orders.bulk-upload')); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <div class="border border-dashed rounded-lg p-6 flex flex-col items-center text-center mb-6">
            <i class="fas fa-upload text-4xl text-gray-400 mb-4"></i>
            <p class="text-gray-500 mb-2">Drag & drop your CSV file here or</p>
            <input type="file" name="csv_file" id="csv_file" class="hidden">
            <label for="csv_file" class="bg-blue-600 text-white px-4 py-2 rounded-md font-semibold cursor-pointer">Select File</label>
        </div>

        <div class="flex flex-wrap gap-4 items-center justify-between mb-6">
            <div class="flex gap-2">
                <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-md font-semibold"><i class="fas fa-upload mr-2"></i> Upload</button>
                <a href="#" class="bg-gray-200 text-gray-700 px-4 py-2 rounded-md font-semibold"><i class="fas fa-download mr-2"></i> Download sample file</a>
            </div>
        </div>
    </form>

    <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead>
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase"><input type="checkbox"></th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Order Ref #</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Customer</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Contact</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Address</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">City</th>
                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Amount</th>
                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Weight (kg)</th>
                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Items</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Action</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <tr>
                    <td colspan="11" class="text-center py-10 text-sm text-gray-500">No file uploaded.</td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="flex items-center gap-4 mt-4">
        <button class="bg-blue-600 text-white px-4 py-2 rounded-md font-semibold"><i class="fas fa-print mr-2"></i> Print Airway Bill (0)</button>
        <button class="bg-gray-200 text-gray-700 px-4 py-2 rounded-md font-semibold">Clear Selection</button>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.seller', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/seller/orders/bulk-upload.blade.php ENDPATH**/ ?>