

<?php $__env->startSection('title', 'Trial Balance'); ?>

<?php $__env->startSection('content'); ?>
<div class="p-6 lg:p-8">
    <!-- Page Header -->
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Trial Balance</h1>
            <p class="text-sm text-gray-600">As of <?php echo e(date('F jS, Y')); ?></p>
        </div>
        <button onclick="window.print();" class="bg-white border border-gray-300 text-gray-700 px-3 py-2 rounded-md hover:bg-gray-50">Print</button>
    </div>

    <!-- Trial Balance Table -->
    <div class="bg-white rounded-lg shadow-md">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Code</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Account</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Debit</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Credit</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__empty_1 = true; $__currentLoopData = $balances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $balance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-500"><?php echo e($balance['account_code']); ?></td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs font-medium text-gray-900"><?php echo e($balance['account_name']); ?></td>
                            <td class="px-6 py-4 text-right text-sm"><?php echo e($balance['debit'] > 0 ? number_format($balance['debit'], 2) : '-'); ?></td>
                            <td class="px-6 py-4 text-right text-sm"><?php echo e($balance['credit'] > 0 ? number_format($balance['credit'], 2) : '-'); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="4" class="text-center py-10 text-gray-500">No accounts with balances found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
                <tfoot class="bg-gray-100">
                    <tr class="font-bold text-gray-900">
                        <td colspan="2" class="px-6 py-3 text-right">Totals</td>
                        <td class="px-6 py-3 text-right">Rs. <?php echo e(number_format($totalDebit, 2)); ?></td>
                        <td class="px-6 py-3 text-right">Rs. <?php echo e(number_format($totalCredit, 2)); ?></td>
                    </tr>
                    <?php if(round($totalDebit, 2) !== round($totalCredit, 2)): ?>
                        <tr>
                            <td colspan="4" class="px-6 py-2 text-center text-red-600 bg-red-50 text-sm">
                                Warning: Totals do not match!
                            </td>
                        </tr>
                    <?php endif; ?>
                </tfoot>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/admin/finance/accounting/trial-balance.blade.php ENDPATH**/ ?>