

<?php $__env->startSection('title', 'Dispute Management'); ?>

<?php $__env->startPush('styles'); ?>
<style>
    body { background: #f8f9fa; }
    .page-container { max-width: 1400px; margin: 0 auto; padding: 30px 20px; }
    .page-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 30px; }
    .page-title { font-size: 24px; font-weight: 600; color: #1a1a1a; }
    .btn-primary { background: #3b82f6; color: white; border: none; padding: 10px 20px; border-radius: 6px; font-size: 14px; font-weight: 600; cursor: pointer; }
    .btn-primary:hover { background: #2563eb; }
    
    .stats-grid { display: grid; grid-template-columns: repeat(4, 1fr); gap: 20px; margin-bottom: 30px; }
    .stat-card { background: white; border-radius: 12px; padding: 20px; border: 1px solid #e5e7eb; }
    .stat-label { font-size: 13px; color: #6b7280; margin-bottom: 8px; }
    .stat-value { font-size: 28px; font-weight: 700; color: #1a1a1a; }
    .stat-value.danger { color: #ef4444; }
    .stat-value.warning { color: #f59e0b; }
    
    .table-card { background: white; border-radius: 12px; border: 1px solid #e5e7eb; overflow: hidden; }
    .table-header { padding: 20px; border-bottom: 1px solid #e5e7eb; }
    .data-table { width: 100%; border-collapse: collapse; }
    .data-table thead th { background: #f9fafb; padding: 12px 20px; text-align: left; font-size: 12px; font-weight: 600; color: #6b7280; text-transform: uppercase; }
    .data-table tbody td { padding: 16px 20px; border-bottom: 1px solid #f3f4f6; font-size: 14px; }
    .data-table tbody tr:hover { background: #f9fafb; }
    
    .badge { padding: 4px 12px; border-radius: 12px; font-size: 12px; font-weight: 600; }
    .badge-open { background: #fee2e2; color: #991b1b; }
    .badge-in-review { background: #fef3c7; color: #92400e; }
    .badge-resolved { background: #d1fae5; color: #065f46; }
    .badge-closed { background: #e5e7eb; color: #4b5563; }
    .badge-escalated { background: #fecaca; color: #7f1d1d; }
    
    .priority-badge { padding: 4px 8px; border-radius: 4px; font-size: 11px; font-weight: 600; text-transform: uppercase; }
    .priority-urgent { background: #fee2e2; color: #991b1b; }
    .priority-high { background: #fed7aa; color: #92400e; }
    .priority-medium { background: #fef3c7; color: #854d0e; }
    .priority-low { background: #e5e7eb; color: #4b5563; }
    
    .action-btn { background: none; border: none; color: #3b82f6; cursor: pointer; padding: 4px 8px; font-size: 14px; }
    .action-btn:hover { color: #2563eb; text-decoration: underline; }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="page-container">
    <div class="page-header">
        <h1 class="page-title">Dispute Management</h1>
<a href="<?php echo e(route('finance.settlements.disputes.create')); ?>" class="btn-primary">
            <i class="fas fa-plus me-2"></i>New Dispute
        </a>
    </div>

    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-label">Open Disputes</div>
            <div class="stat-value danger"><?php echo e($stats['total_open']); ?></div>
            <div style="font-size: 13px; color: #6b7280; margin-top: 8px;">Requires attention</div>
        </div>
        <div class="stat-card">
            <div class="stat-label">In Review</div>
            <div class="stat-value warning"><?php echo e($stats['total_in_review']); ?></div>
            <div style="font-size: 13px; color: #6b7280; margin-top: 8px;">Being processed</div>
        </div>
        <div class="stat-card">
            <div class="stat-label">Urgent</div>
            <div class="stat-value" style="color: #ef4444;"><?php echo e($stats['total_urgent']); ?></div>
            <div style="font-size: 13px; color: #6b7280; margin-top: 8px;">High priority</div>
        </div>
        <div class="stat-card">
            <div class="stat-label">Resolved This Month</div>
            <div class="stat-value" style="color: #10b981;"><?php echo e($stats['resolved_this_month']); ?></div>
            <div style="font-size: 13px; color: #6b7280; margin-top: 8px;">Successfully closed</div>
        </div>
    </div>

    <div class="table-card">
        <div class="table-header">
            <h3 style="font-size: 16px; font-weight: 600; margin: 0;">All Disputes</h3>
        </div>
        
        <table class="data-table">
            <thead>
                <tr>
                    <th>Dispute #</th>
                    <th>Merchant</th>
                    <th>Subject</th>
                    <th>Type</th>
                    <th>Amount</th>
                    <th>Priority</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $disputes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dispute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><strong><?php echo e($dispute->dispute_number); ?></strong></td>
                    <td><?php echo e($dispute->merchant->name ?? 'N/A'); ?></td>
                    <td><?php echo e(Str::limit($dispute->subject, 40)); ?></td>
                    <td><?php echo e(ucfirst(str_replace('_', ' ', $dispute->dispute_type))); ?></td>
                    <td>
                        <?php if($dispute->disputed_amount): ?>
                            <strong>Rs. <?php echo e(number_format($dispute->disputed_amount, 2)); ?></strong>
                        <?php else: ?>
                            <span style="color: #9ca3af;">-</span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <span class="priority-badge priority-<?php echo e($dispute->priority); ?>"><?php echo e(ucfirst($dispute->priority)); ?></span>
                    </td>
                    <td>
                        <?php if($dispute->status == 'open'): ?>
                            <span class="badge badge-open">Open</span>
                        <?php elseif($dispute->status == 'in_review'): ?>
                            <span class="badge badge-in-review">In Review</span>
                        <?php elseif($dispute->status == 'resolved'): ?>
                            <span class="badge badge-resolved">Resolved</span>
                        <?php elseif($dispute->status == 'escalated'): ?>
                            <span class="badge badge-escalated">Escalated</span>
                        <?php else: ?>
                            <span class="badge badge-closed">Closed</span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <a href="<?php echo e(route('finance.settlements.disputes.show', $dispute)); ?>" class="action-btn">View</a>
                        <?php if($dispute->status == 'open'): ?>
<form action="<?php echo e(route('finance.settlements.disputes.assign', $dispute)); ?>" method="POST" style="display: inline;">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="assigned_to" value="<?php echo e(auth()->id()); ?>">
                            <button type="submit" class="action-btn" style="color: #10b981;">Assign to Me</button>
                        </form>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="8" style="text-align: center; padding: 40px; color: #9ca3af;">
                        <i class="fas fa-inbox" style="font-size: 48px; margin-bottom: 16px; display: block;"></i>
                        No disputes found
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
        
        <?php if($disputes->hasPages()): ?>
        <div style="padding: 20px; border-top: 1px solid #e5e7eb;">
            <?php echo e($disputes->links()); ?>

        </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/admin/finance/settlements/disputes/index.blade.php ENDPATH**/ ?>