<aside id="sidebar" class="w-56 bg-white border-r border-gray-200 min-h-screen fixed left-0 top-16 bottom-0 overflow-y-auto z-20" x-data="{ open: '' }">
    <nav class="py-2">
        <?php
            $user = auth()->user();

            $menu = [
                [
                    'title' => 'OVERVIEW',
                    'items' => [
                        ['href' => 'admin.dashboard', 'label' => 'Dashboard', 'icon' => 'fa-home'],
                        ['href' => 'admin.parcels.index', 'label' => 'Shipments', 'icon' => 'fa-truck'],
                        ['href' => 'admin.spans.index', 'label' => 'Spans', 'icon' => 'fa-layer-group'],
                    ]
                ],
                [
                    'title' => 'MERCHANTS',
                    'items' => [
                        ['href' => 'admin.merchants.index', 'label' => 'Merchants', 'icon' => 'fa-users'],
                    ]
                ],
                [
                    'title' => 'FINANCE, TAX & ACCOUNTING',
                    'items' => [
                        ['href' => 'finance.dashboard', 'label' => 'Dashboard', 'icon' => 'fa-chart-pie'],
                        ['label' => 'Cash & COD Management', 'icon' => 'fa-dollar-sign', 'sub-items' => [
                            ['href' => 'finance.cod.daily-collection', 'label' => 'Daily Cash Collection'],
                            ['href' => 'finance.cod.deposits', 'label' => 'Deposits to Bank'],
                            ['href' => 'finance.cod.pending-report', 'label' => 'Pending COD Report'],
                            ['href' => 'finance.cod.variance-report', 'label' => 'COD Variance Report'],
                        ]],
                        ['label' => 'Merchant Settlements', 'icon' => 'fa-hand-holding-usd', 'sub-items' => [
                            ['href' => 'finance.settlements.invoices.index', 'label' => 'Invoices'],
                            ['href' => 'finance.settlements.payments.index', 'label' => 'Payments to Merchants'],
                            ['href' => 'finance.settlements.deductions.index', 'label' => 'Deductions'],
                            ['href' => 'finance.settlements.pending-report', 'label' => 'Pending Settlement Report'],
                            ['href' => 'finance.settlements.disputes.index', 'label' => 'Dispute Management'],
                        ]],
                        ['label' => 'Company Accounting', 'icon' => 'fa-book', 'sub-items' => [
                            ['href' => 'finance.accounting.chart-of-accounts', 'label' => 'Chart of Accounts'],
                            ['href' => 'finance.accounting.journal-entries', 'label' => 'Journal Entries'],
                            ['href' => 'finance.accounting.ledger', 'label' => 'Ledger View'],
                            ['href' => 'finance.accounting.trial-balance', 'label' => 'Trial Balance'],
                            ['href' => 'finance.accounting.balance-sheet', 'label' => 'Balance Sheet'],
                            ['href' => 'finance.accounting.profit-loss', 'label' => 'Profit & Loss Statement'],
                        ]],
                        ['label' => 'Expenses & Payments', 'icon' => 'fa-receipt', 'sub-items' => [
                            ['href' => 'finance.expenses.company', 'label' => 'Company Expenses'],
                            ['href' => 'finance.expenses.branch', 'label' => 'Branch Level Expenses'],
                            ['href' => 'finance.expenses.vendor-payments', 'label' => 'Vendor Payments'],
                            ['href' => 'finance.expenses.approval-flow', 'label' => 'Expense Approval Flow'],
                            ['href' => 'finance.expenses.recurring', 'label' => 'Recurring Expenses'],
                        ]],
                        ['label' => 'Payroll & Salaries', 'icon' => 'fa-wallet', 'sub-items' => [
                            ['href' => 'finance.payroll.employee-master', 'label' => 'Employee Master Data'],
                            ['href' => 'finance.payroll.attendance', 'label' => 'Attendance & Overtime'],
                            ['href' => 'finance.payroll.payroll-run', 'label' => 'Payroll Run'],
                            ['href' => 'finance.payroll.tax-deductions', 'label' => 'Tax Deductions'],
                            ['href' => 'finance.payroll.salary-slips', 'label' => 'Salary Slips'],
                            ['href' => 'finance.payroll.bonus-incentives', 'label' => 'Bonus & Incentives'],
                        ]],
                        ['label' => 'Taxation & Compliance', 'icon' => 'fa-calculator', 'sub-items' => [
                            ['href' => 'finance.taxation.gst-calculation', 'label' => 'GST Calculation'],
                            ['href' => 'finance.taxation.income-tax', 'label' => 'Income Tax Withholding'],
                            ['href' => 'finance.taxation.filings', 'label' => 'Tax Filings'],
                            ['href' => 'finance.taxation.e-filing', 'label' => 'e-Filing Integration'],
                            ['href' => 'finance.taxation.deduction-reports', 'label' => 'Tax Deduction Reports'],
                            ['href' => 'finance.taxation.calendar-alerts', 'label' => 'Tax Calendar Alerts'],
                        ]],
                        ['label' => 'Banking & Reconciliation', 'icon' => 'fa-landmark', 'sub-items' => [
                            ['href' => 'finance.banking.accounts', 'label' => 'Bank Accounts Linked'],
                            ['href' => 'finance.banking.reconciliation', 'label' => 'Bank Reconciliation'],
                            ['href' => 'finance.banking.cheques', 'label' => 'Cheque Management'],
                            ['href' => 'finance.banking.discrepancies', 'label' => 'Discrepancy Alerts'],
                        ]],
                        ['label' => 'Vouchers & Manual Entry', 'icon' => 'fa-file-signature', 'sub-items' => [
                            ['href' => ['finance.vouchers.index', ['type' => 'cash-payment']], 'label' => 'Cash Payment Voucher'],
                            ['href' => ['finance.vouchers.index', ['type' => 'bank-payment']], 'label' => 'Bank Payment Voucher'],
                            ['href' => ['finance.vouchers.index', ['type' => 'cash-receipt']], 'label' => 'Cash Receipt Voucher'],
                            ['href' => ['finance.vouchers.index', ['type' => 'bank-receipt']], 'label' => 'Bank Receipt Voucher'],
                            ['href' => ['finance.vouchers.index', ['type' => 'journal']], 'label' => 'Journal Voucher'],
                            ['href' => ['finance.vouchers.index', ['type' => 'contra']], 'label' => 'Contra Voucher'],
                        ]],
                        ['label' => 'Audit & Controls', 'icon' => 'fa-shield-check', 'sub-items' => [
                            ['href' => 'finance.audit.internal-audit', 'label' => 'Role Based Access'],
                            ['href' => '#', 'label' => 'Approval Flow'],
                            ['href' => 'finance.audit.access-controls', 'label' => 'Audit Logs'],
                            ['href' => '#', 'label' => 'System Alerts'],
                        ]],
                        ['label' => 'Reports & Analytics', 'icon' => 'fa-chart-line', 'sub-items' => [
                            ['href' => 'finance.reports.financial', 'label' => 'Daily COD Report'],
                            ['href' => '#', 'label' => 'Merchant Settlement'],
                            ['href' => 'finance.banking.reconciliation', 'label' => 'Bank Reconciliation'],
                            ['href' => '#', 'label' => 'Daily Cash Flow Report'],
                            ['href' => '#', 'label' => 'COD vs Deposit Report'],
                            ['href' => '#', 'label' => 'Settlement Aging Report'],
                            ['href' => '#', 'label' => 'Expense vs Budget Report'],
                            ['href' => '#', 'label' => 'Payroll Cost Analysis'],
                            ['href' => '#', 'label' => 'Branch Profitability'],
                            ['href' => 'finance.taxation.deduction-reports', 'label' => 'Tax Reports'],
                            ['href' => 'finance.reports.financial', 'label' => 'Financial Statements'],
                        ]],
                    ]
                ],
                [
                    'title' => 'MARKETING & SALES',
                    'items' => [
                        ['href' => 'admin.marketing.dashboard', 'label' => 'Dashboard', 'icon' => 'fa-tachometer-alt'],
                        ['href' => 'admin.marketing.alerts', 'label' => 'Alerts', 'icon' => 'fa-bell'],
                        ['label' => 'Management', 'icon' => 'fa-users-cog', 'sub-items' => [
                            ['href' => 'admin.marketing.management.profiles', 'label' => 'Profiles'],
                            ['href' => 'admin.marketing.management.hierarchy', 'label' => 'Hierarchy'],
                            ['href' => 'admin.marketing.management.walletStatus', 'label' => 'Wallet Status'],
                            ['href' => 'admin.marketing.management.shipmentSummary', 'label' => 'Shipment Summary'],
                        ]],
                        ['label' => 'Rates', 'icon' => 'fa-dollar-sign', 'sub-items' => [
                            ['href' => 'admin.marketing.rates.pricing.index', 'label' => 'Pricing'],
                            ['href' => 'admin.marketing.rates.discounts.index', 'label' => 'Discounts'],
                            ['href' => 'admin.marketing.rates.zones.index', 'label' => 'Zones'],
                        ]],
                        ['label' => 'Documents', 'icon' => 'fa-file-alt', 'sub-items' => [
                            ['href' => 'admin.marketing.documents.templates.index', 'label' => 'Templates'],
                            ['href' => 'admin.marketing.documents.contracts.index', 'label' => 'Contracts'],
                            ['href' => 'admin.marketing.documents.compliance.index', 'label' => 'Compliance'],
                        ]],
                        ['href' => 'admin.marketing.leads.index', 'label' => 'Lead Management', 'icon' => 'fa-user-plus'],
                        ['href' => 'admin.marketing.territories.index', 'label' => 'Territory Mapping', 'icon' => 'fa-map-marked-alt'],
                        ['href' => 'admin.marketing.contracts.index', 'label' => 'Contract Vault', 'icon' => 'fa-file-contract'],
                        ['label' => 'Complaints', 'icon' => 'fa-exclamation-triangle', 'sub-items' => [
                            ['href' => 'admin.complaints.create', 'label' => 'New Complaint'],
                            ['href' => 'admin.complaints.index', 'label' => 'Complaint Tracker'],
                            ['href' => '#', 'label' => 'Escalation Matrix'],
                        ]],
                        ['label' => 'Tools', 'icon' => 'fa-tools', 'sub-items' => [
                            ['href' => 'admin.marketing.communication-log', 'label' => 'Communication Log'],
                            ['href' => 'admin.marketing.task-manager', 'label' => 'Task Manager'],
                            ['href' => 'admin.marketing.sentiment-tracking', 'label' => 'Sentiment Tracking'],
                            ['href' => 'admin.marketing.live-chat', 'label' => 'Live Chat'],
                        ]],
                        ['href' => '#', 'label' => 'COD Status', 'icon' => 'fa-money-bill-wave'],
                        ['href' => 'finance.settlements.invoices.index', 'label' => 'Invoice Panel', 'icon' => 'fa-file-invoice'],
                        ['href' => 'finance.settlements.disputes.index', 'label' => 'Finance Disputes', 'icon' => 'fa-balance-scale-left'],
                        ['href' => 'admin.marketing.leads.index', 'label' => 'Lead Management', 'icon' => 'fa-user-plus'],
                        ['href' => 'admin.marketing.territories.index', 'label' => 'Territory Mapping', 'icon' => 'fa-map-marked-alt'],
                        ['href' => 'admin.marketing.target-achievement', 'label' => 'Target vs Achievement', 'icon' => 'fa-bullseye'],
                        ['href' => 'admin.marketing.pipeline-tracker', 'label' => 'Pipeline Tracker', 'icon' => 'fa-filter'],
                        ['href' => '#', 'label' => 'Lost Lead Analysis', 'icon' => 'fa-search-minus'],
                        ['href' => 'admin.marketing.merchant-ranking', 'label' => 'Merchant Ranking', 'icon' => 'fa-trophy'],
                        ['href' => '#', 'label' => 'Sales Team Ranking', 'icon' => 'fa-award'],
                        ['href' => '#', 'label' => 'Regional Heatmap', 'icon' => 'fa-map-pin'],
                        ['href' => '#', 'label' => 'Churn Analysis', 'icon' => 'fa-chart-area'],
                        ['label' => 'Reports', 'icon' => 'fa-chart-bar', 'sub-items' => [
                            ['href' => 'finance.settlements.invoices.index', 'label' => 'Merchant Settlement'],
                            ['href' => 'admin.support.reports.sla-breach', 'label' => 'Complaint SLA Breach'],
                            ['href' => '#', 'label' => 'Regional Performance'],
                            ['href' => '#', 'label' => 'Retention & Churn'],
                            ['href' => '#', 'label' => 'Return & RTO'],
                            ['href' => '#', 'label' => 'Rate Card Report'],
                        ]],
                        ['href' => 'admin.marketing.contracts.index', 'label' => 'Contract Vault', 'icon' => 'fa-file-contract'],
                        ['href' => 'admin.marketing.expiry-alerts', 'label' => 'Expiry Alerts', 'icon' => 'fa-bell'],
                        ['href' => 'admin.marketing.rate-change-requests', 'label' => 'Rate Change Requests', 'icon' => 'fa-pen'],
                        ['href' => '#', 'label' => 'Digital Signatures', 'icon' => 'fa-signature'],
                        ['href' => '#', 'label' => 'Staff Payouts', 'icon' => 'fa-money-check-alt'],
                        ['href' => '#', 'label' => 'Staff Attendance', 'icon' => 'fa-user-check'],
                        ['href' => 'admin.compliance.audit-logs', 'label' => 'Audit Log', 'icon' => 'fa-history'],
                        ['href' => 'admin.settings.users', 'label' => 'Role-based Access', 'icon' => 'fa-user-shield'],
                    ]
                ],
                [
                    'title' => 'SUPPORT & COMPLAINTS',
                    'items' => [
                        ['href' => 'admin.support.dashboard', 'label' => 'Dashboard', 'icon' => 'fa-life-ring'],
                        ['label' => 'Tickets', 'icon' => 'fa-ticket-alt', 'sub-items' => [
                            ['href' => 'admin.complaints.create', 'label' => 'New Complaint'],
                            ['href' => 'admin.support.tickets.open', 'label' => 'In-Progress'],
                            ['href' => 'admin.support.tickets.resolved', 'label' => 'Resolved'],
                            ['href' => 'admin.support.tickets.escalated', 'label' => 'Escalated'],
                            ['href' => '#', 'label' => 'Auto-Closure Rules'],
                        ]],
                        ['label' => 'Interaction Logs', 'icon' => 'fa-history', 'sub-items' => [
                            ['href' => '#', 'label' => 'Call Log'],
                            ['href' => '#', 'label' => 'Chat Log'],
                            ['href' => '#', 'label' => 'Email Log'],
                        ]],
                        ['label' => 'Knowledge Base', 'icon' => 'fa-book-open', 'sub-items' => [
                            ['href' => 'admin.support.kb.faqs', 'label' => 'FAQ'],
                            ['href' => 'admin.support.kb.quick-replies', 'label' => 'Quick Replies'],
                            ['href' => 'admin.support.kb.sop', 'label' => 'SOP Library'],
                        ]],
                        ['href' => '#', 'label' => 'Customer Tracking', 'icon' => 'fa-user-tag'],
                        ['label' => 'Reports & Analytics', 'icon' => 'fa-chart-pie', 'sub-items' => [
                            ['href' => 'admin.support.reports.daily', 'label' => 'Daily Ticket Report'],
                            ['href' => 'admin.support.reports.sla-breach', 'label' => 'SLA Breach Report'],
                            ['href' => '#', 'label' => 'Complaint Trend'],
                            ['href' => '#', 'label' => 'Top Merchants by Complaint'],
                            ['href' => '#', 'label' => 'Root Cause Analysis'],
                            ['href' => 'admin.support.reports.agent-performance', 'label' => 'Agent Performance'],
                        ]],
                        ['label' => 'Quality & Feedback', 'icon' => 'fa-star', 'sub-items' => [
                            ['href' => '#', 'label' => 'Post-Resolution Feedback'],
                            ['href' => '#', 'label' => 'NPS Dashboard'],
                            ['href' => '#', 'label' => 'Quality Team Review'],
                        ]],
                        ['label' => 'System & Security', 'icon' => 'fa-cogs', 'sub-items' => [
                            ['href' => 'admin.settings.users', 'label' => 'Role-Based Access'],
                            ['href' => 'admin.compliance.audit-logs', 'label' => 'Audit Trail'],
                        ]],
                    ]
                ],
                [
                    'title' => 'RIDER OPS',
                    'items' => [
                        ['href' => 'admin.riders.dashboard', 'label' => 'Dashboard', 'icon' => 'fa-biking'],
                        ['label' => 'Rider Management', 'icon' => 'fa-users', 'sub-items' => [
                            ['href' => 'admin.riders.profiles', 'label' => 'Rider Profiles'],
                            ['href' => 'admin.riders.attendance', 'label' => 'Attendance / Shift Logs'],
                            ['href' => 'admin.riders.gps-tracking', 'label' => 'Live GPS Tracking'],
                        ]],
                        ['label' => 'Delivery Operations', 'icon' => 'fa-route', 'sub-items' => [
                            ['href' => 'admin.riders.assign-parcels', 'label' => 'Assign Parcels'],
                        ]],
                        ['label' => 'Performance & Reports', 'icon' => 'fa-chart-line', 'sub-items' => [
                            ['href' => 'admin.riders.performance.efficiency', 'label' => 'Rider Efficiency'],
                            ['href' => 'admin.riders.performance.handover', 'label' => 'Daily Handover'],
                            ['href' => '#', 'label' => 'Complaint Ratio'],
                            ['href' => 'admin.riders.performance.top-riders', 'label' => 'Top Riders'],
                            ['href' => '#', 'label' => 'Weak Riders'],
                        ]],
                        ['label' => 'Finance Link (COD)', 'icon' => 'fa-link', 'sub-items' => [
                            ['href' => 'admin.riders.finance.cash-collection', 'label' => 'Rider Cash Collection'],
                            ['href' => 'admin.riders.finance.pending-cod', 'label' => 'Pending COD Submission'],
                            ['href' => 'admin.riders.finance.discrepancy', 'label' => 'Discrepancy Report'],
                        ]],
                        ['label' => 'Complaints & Escalations', 'icon' => 'fa-exclamation-circle', 'sub-items' => [
                            ['href' => 'admin.complaints.index', 'label' => 'Rider Related Complaints'],
                            ['href' => '#', 'label' => 'Action History'],
                            ['href' => '#', 'label' => 'Customer Feedback'],
                        ]],
                    ]
                ],
                [
                    'title' => 'HR & EMPLOYEES',
                    'items' => [
                        ['href' => 'admin.hr.dashboard', 'label' => 'Dashboard', 'icon' => 'fa-id-card'],
                        ['href' => 'admin.hr.employees', 'label' => 'Employee Directory', 'icon' => 'fa-address-book'],
                        ['href' => 'admin.hr.recruitment', 'label' => 'Recruitment', 'icon' => 'fa-user-plus'],
                        ['href' => 'admin.hr.attendance', 'label' => 'Attendance & Leaves', 'icon' => 'fa-calendar-check'],
                        ['href' => 'admin.hr.exit-handover', 'label' => 'Exit & Handover', 'icon' => 'fa-sign-out-alt'],
                        ['href' => 'admin.finance.payroll.payroll-run', 'label' => 'Payroll', 'icon' => 'fa-file-invoice-dollar'],
                        ['href' => 'admin.hr.performance-kpis', 'label' => 'Performance & KPIs', 'icon' => 'fa-chart-bar'],
                        ['href' => 'admin.hr.documents', 'label' => 'Training & Documents', 'icon' => 'fa-folder-open'],
                    ]
                ],
                [
                    'title' => 'BRANCH OPERATIONS',
                    'items' => [
                        ['href' => '#', 'label' => 'Bagging', 'icon' => 'fa-archive'],
                        ['href' => '#', 'label' => 'Unbagging', 'icon' => 'fa-box-open'],
                        ['href' => '#', 'label' => 'Pickup Orders', 'icon' => 'fa-box-check'],
                        ['href' => '#', 'label' => 'Receive Shipments', 'icon' => 'fa-scanner-gun'],
                        ['href' => '#', 'label' => 'Dispatch Shipments', 'icon' => 'fa-upload'],
                        ['href' => '#', 'label' => 'Carrier Manifest', 'icon' => 'fa-file-chart-line'],
                        ['href' => '#', 'label' => 'Deliveries Assigned', 'icon' => 'fa-user-check'],
                        ['href' => '#', 'label' => 'Successful Deliveries', 'icon' => 'fa-thumbs-up'],
                        ['href' => '#', 'label' => 'Failed Deliveries', 'icon' => 'fa-thumbs-down'],
                        ['href' => '#', 'label' => 'Reattempt Shipment', 'icon' => 'fa-clipboard-check'],
                        ['href' => '#', 'label' => 'Return Shipments (RTO)', 'icon' => 'fa-sync-alt'],
                        ['href' => '#', 'label' => 'Forward to Origin / Hub', 'icon' => 'fa-exchange-alt'],
                        ['href' => '#', 'label' => 'Shipment Tracking', 'icon' => 'fa-search-location'],
                        ['href' => '#', 'label' => 'Search Bag', 'icon' => 'fa-fingerprint'],
                        ['href' => '#', 'label' => 'Lost / Hold', 'icon' => 'fa-exclamation-triangle'],
                        ['href' => '#', 'label' => 'Onboarding', 'icon' => 'fa-user-plus'],
                        ['href' => '#', 'label' => 'Rider Daily Load', 'icon' => 'fa-clipboard-list'],
                        ['href' => '#', 'label' => 'COD Value Assigned', 'icon' => 'fa-dollar-sign'],
                        ['href' => '#', 'label' => 'Manage Staff', 'icon' => 'fa-users'],
                        ['href' => '#', 'label' => 'Staff Salary', 'icon' => 'fa-hand-holding-usd'],
                        ['href' => '#', 'label' => 'Attendance', 'icon' => 'fa-clock'],
                        ['href' => '#', 'label' => 'Rider Handover', 'icon' => 'fa-wallet'],
                        ['href' => '#', 'label' => 'Pending COD', 'icon' => 'fa-hourglass-half'],
                        ['href' => '#', 'label' => 'Variance Report', 'icon' => 'fa-chart-bar'],
                        ['href' => '#', 'label' => 'Collect COD', 'icon' => 'fa-circle-dollar-to-slot'],
                        ['href' => '#', 'label' => 'Mark Deposited', 'icon' => 'fa-money-check-alt'],
                        ['href' => '#', 'label' => 'Cash in Transit', 'icon' => 'fa-layer-group'],
                        ['href' => '#', 'label' => 'Register Complaint', 'icon' => 'fa-comment-alt-exclamation'],
                        ['href' => '#', 'label' => 'Shipment Reports', 'icon' => 'fa-chart-line'],
                        ['href' => '#', 'label' => 'Sync Status', 'icon' => 'fa-history'],
                        ['href' => '#', 'label' => 'Audit Trail', 'icon' => 'fa-file-clock'],
                        ['href' => '#', 'label' => 'Activity Log', 'icon' => 'fa-history'],
                    ]
                ],
                [
                    'title' => 'LOGISTICS & OPS',
                    'items' => [
                        ['href' => 'admin.logistics.bagging-manifest', 'label' => 'Bagging & Manifest', 'icon' => 'fa-archive'],
                        ['href' => 'admin.logistics.vehicle-dispatch', 'label' => 'Vehicle Dispatch', 'icon' => 'fa-truck'],
                        ['href' => '#', 'label' => 'Shortage/Loss Reports', 'icon' => 'fa-file-excel'],
                        ['href' => 'branch.return-shipments', 'label' => 'Return Shipments', 'icon' => 'fa-undo'],
                        ['href' => 'admin.logistics.routing-efficiency', 'label' => 'Routing Efficiency', 'icon' => 'fa-route'],
                    ]
                ],
                [
                    'title' => 'COMPLIANCE & AUDIT',
                    'items' => [
                        ['href' => 'admin.compliance.audit-logs', 'label' => 'Internal Audit Logs', 'icon' => 'fa-clipboard-list'],
                        ['href' => 'admin.compliance.fraud-detection', 'label' => 'Fraud Detection', 'icon' => 'fa-user-secret'],
                        ['href' => 'admin.compliance.tax-compliance', 'label' => 'Tax Compliance Status', 'icon' => 'fa-balance-scale'],
                        ['href' => 'admin.compliance.branch-errors', 'label' => 'Branch Error Reports', 'icon' => 'fa-exclamation-circle'],
                    ]
                ],
                [
                    'title' => 'SYSTEM SETTINGS & CONTROL',
                    'items' => [
                        ['href' => 'admin.settings.users', 'label' => 'User Roles & Permissions', 'icon' => 'fa-user-shield'],
                        ['href' => 'admin.settings.module-integrations', 'label' => 'Module Integrations', 'icon' => 'fa-puzzle-piece'],
                        ['href' => 'admin.settings.security', 'label' => 'Security & Backups', 'icon' => 'fa-lock'],
                        ['href' => 'admin.settings.api-access', 'label' => 'API Access', 'icon' => 'fa-key'],
                        ['href' => 'admin.settings.internal-updates', 'label' => 'Internal Updates', 'icon' => 'fa-sync-alt'],
                        ['href' => 'admin.divs.index', 'label' => 'Divs', 'icon' => 'fa-building'],
                    ]
                ],
            ];
        ?>

        <?php $__currentLoopData = $menu; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if(!isset($group['role']) || $user->hasAnyRole($group['role'])): ?>
            <div class="mb-1">
                <h3 class="px-3 py-2 font-semibold text-primary uppercase text-xs tracking-wider"><?php echo e($group['title']); ?></h3>
                <div class="flex flex-col gap-1">
                    <?php $__currentLoopData = $group['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(isset($item['sub-items'])): ?>
                            <div x-data="{ open: false }">
                                <button @click="open = !open" class="w-full flex items-center justify-between px-3 py-1.5 text-sm text-gray-700 hover:bg-blue-50">
                                    <span class="flex items-center">
                                        <i class="fas <?php echo e($item['icon']); ?> w-5 h-5 mr-3"></i>
                                        <span><?php echo e($item['label']); ?></span>
                                    </span>
                                    <i class="fas fa-chevron-down w-3 h-3 transition-transform" :class="{ 'rotate-180': open }"></i>
                                </button>
                                <div x-show="open" class="pl-8 mt-1 space-y-1">
                                    <?php $__currentLoopData = $item['sub-items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <a href="<?php echo e(is_array($subItem['href']) ? (\Illuminate\Support\Facades\Route::has($subItem['href'][0]) ? route($subItem['href'][0], $subItem['href'][1]) : '#') : ($subItem['href'] === '#' ? '#' : (\Illuminate\Support\Facades\Route::has($subItem['href']) ? route($subItem['href']) : '#'))); ?>" class="block text-xs text-gray-600 hover:text-blue-600"><?php echo e($subItem['label']); ?></a>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        <?php else: ?>
                            <a href="<?php echo e(is_array($item['href']) ? (\Illuminate\Support\Facades\Route::has($item['href'][0]) ? route($item['href'][0], $item['href'][1]) : '#') : ($item['href'] === '#' ? '#' : (\Illuminate\Support\Facades\Route::has($item['href']) ? route($item['href']) : '#'))); ?>"
                               class="flex items-center px-3 py-1.5 text-sm text-gray-700 hover:bg-blue-50 <?php echo e((isset($item['href']) && !is_array($item['href']) && $item['href'] !== '#' && request()->routeIs($item['href'])) ? 'bg-blue-50 text-blue-600 font-bold border-r-4 border-blue-600' : ''); ?>">
                                <i class="fas <?php echo e($item['icon']); ?> w-5 h-5 mr-3"></i>
                                <span><?php echo e($item['label']); ?></span>
                            </a>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </nav>
</aside>


<?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/partials/new-admin-sidebar.blade.php ENDPATH**/ ?>