

<?php $__env->startSection('title', 'General Ledger'); ?>

<?php $__env->startSection('content'); ?>
<div class="p-6 lg:p-8">
    <!-- Page Header -->
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">General Ledger</h1>
            <p class="text-sm text-gray-600">View detailed transactions for any account.</p>
        </div>
    </div>

    <!-- Filter Form -->
    <div class="bg-white rounded-lg shadow-md p-4 mb-6">
        <form method="GET" action="<?php echo e(route('finance.accounting.ledger')); ?>" class="grid grid-cols-1 md:grid-cols-4 gap-4 items-end">
            <div class="md:col-span-2">
                <label for="account_id" class="block text-xs sm:text-sm font-medium text-gray-700">Account</label>
                <select name="account_id" id="account_id" class="mt-1 form-select" required>
                    <option value="">Select an account</option>
                    <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($account->id); ?>" <?php echo e(optional($selectedAccount)->id == $account->id ? 'selected' : ''); ?>>
                            <?php echo e($account->account_code); ?> - <?php echo e($account->account_name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div>
                <label for="start_date" class="block text-xs sm:text-sm font-medium text-gray-700">Start Date</label>
                <input type="date" name="start_date" id="start_date" value="<?php echo e($startDate); ?>" class="mt-1 form-input">
            </div>
            <div>
                <label for="end_date" class="block text-xs sm:text-sm font-medium text-gray-700">End Date</label>
                <input type="date" name="end_date" id="end_date" value="<?php echo e($endDate); ?>" class="mt-1 form-input">
            </div>
            <div>
                <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">View Ledger</button>
            </div>
        </form>
    </div>

    <?php if($selectedAccount): ?>
    <!-- Ledger Table -->
    <div class="bg-white rounded-lg shadow-md">
        <div class="p-4 border-b flex justify-between items-center">
            <h3 class="text-lg font-semibold">Ledger for: <?php echo e($selectedAccount->account_name); ?></h3>
            <div class="text-right">
                <div class="text-sm text-gray-500">Current Balance</div>
                <div class="text-xl font-bold text-gray-800">Rs. <?php echo e(number_format($selectedAccount->balance, 2)); ?></div>
            </div>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Date</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Description</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Reference</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Debit</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Credit</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Running Balance</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $runningBalance = 0; ?>
                    <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <?php
                            if ($transaction->type == 'debit') $runningBalance += $transaction->amount; else $runningBalance -= $transaction->amount;
                        ?>
                        <tr>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-500"><?php echo e($transaction->journalEntry->entry_date->format('M d, Y')); ?></td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-900"><?php echo e($transaction->journalEntry->description); ?></td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-500"><?php echo e($transaction->journalEntry->reference); ?></td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs text-right text-green-600"><?php echo e($transaction->type == 'debit' ? 'Rs. ' . number_format($transaction->amount, 2) : '-'); ?></td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs text-right text-red-600"><?php echo e($transaction->type == 'credit' ? 'Rs. ' . number_format($transaction->amount, 2) : '-'); ?></td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs text-right font-medium">Rs. <?php echo e(number_format($runningBalance, 2)); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="text-center py-10 text-gray-500">No transactions found for this account.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php else: ?>
    <div class="bg-white rounded-lg shadow-md text-center py-10">
        <p class="text-gray-500">Please select an account to view its ledger.</p>
    </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/admin/finance/accounting/ledger.blade.php ENDPATH**/ ?>