
<?php $__env->startSection('title', 'Seller Panel'); ?>

<?php $__env->startSection('content'); ?>
<form action="<?php echo e(route('seller.dashboard')); ?>" method="GET" class="space-y-6">
    <div class="flex justify-end items-center gap-4">
        <div>
            <label for="from_date" class="text-sm font-medium">From</label>
            <input type="date" name="from_date" value="<?php echo e(request('from_date')); ?>" class="border-gray-300 rounded-md shadow-sm">
        </div>
        <div>
            <label for="to_date" class="text-sm font-medium">To</label>
            <input type="date" name="to_date" value="<?php echo e(request('to_date')); ?>" class="border-gray-300 rounded-md shadow-sm">
        </div>
        <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-md font-semibold">Filter</button>
        <a href="<?php echo e(route('seller.dashboard')); ?>" class="bg-gray-200 text-gray-700 px-4 py-2 rounded-md font-semibold">Clear</a>
    </div>
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
        <div class="bg-white p-4 rounded-lg shadow-sm">
            <div class="flex justify-between items-center">
                <h3 class="text-sm font-medium text-gray-600">Wallet / COD Balance</h3>
                <select class="text-xs border-none focus:ring-0 bg-transparent">
                    <option>Last 3 days</option>
                </select>
            </div>
            <p class="text-2xl font-bold mt-2"><i class="fas fa-wallet text-gray-400 mr-2"></i>PKR <?php echo e(number_format($walletBalance ?? 0, 2)); ?></p>
        </div>
        <div class="bg-white p-4 rounded-lg shadow-sm">
            <h3 class="text-sm font-medium text-gray-600">Today's Booked</h3>
            <p class="text-2xl font-bold mt-2"><i class="fas fa-box text-gray-400 mr-2"></i><?php echo e($todaysBooked ?? 0); ?></p>
        </div>
        <div class="bg-white p-4 rounded-lg shadow-sm">
            <h3 class="text-sm font-medium text-gray-600">Delivered</h3>
            <p class="text-2xl font-bold mt-2"><i class="fas fa-check-circle text-green-500 mr-2"></i><?php echo e($deliveredParcels ?? 0); ?></p>
        </div>
        <div class="bg-white p-4 rounded-lg shadow-sm">
            <h3 class="text-sm font-medium text-gray-600">Return</h3>
            <p class="text-2xl font-bold mt-2"><i class="fas fa-undo-alt text-red-500 mr-2"></i><?php echo e($returnedParcels ?? 0); ?></p>
        </div>
    </div>

    <div class="bg-white p-6 rounded-lg shadow-sm">
        <div class="flex justify-between items-center mb-4">
            <h2 class="text-lg font-semibold text-gray-800">Order Status Overview</h2>
            <select class="text-sm border-gray-300 rounded-md">
                <option>Last 7 days</option>
            </select>
        </div>
        <div class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-8 gap-4 text-center">
            <?php
                $statuses = [
                    ['icon' => 'fa-box', 'label' => 'Total Orders', 'count' => $totalParcels ?? 0, 'color' => 'text-blue-500'],
                    ['icon' => 'fa-box-open', 'label' => 'Unbooked', 'count' => 0, 'color' => 'text-gray-500'],
                    ['icon' => 'fa-warehouse', 'label' => 'In Warehouse', 'count' => 0, 'color' => 'text-gray-500'],
                    ['icon' => 'fa-truck', 'label' => 'Out for Delivery', 'count' => 0, 'color' => 'text-gray-500'],
                    ['icon' => 'fa-phone-alt', 'label' => 'Attempted', 'count' => 0, 'color' => 'text-orange-500'],
                    ['icon' => 'fa-shipping-fast', 'label' => 'Out for Return', 'count' => 0, 'color' => 'text-orange-500'],
                    ['icon' => 'fa-undo-alt', 'label' => 'Returned', 'count' => $returnedParcels ?? 0, 'color' => 'text-red-500'],
                    ['icon' => 'fa-user-check', 'label' => 'Shipper Advice', 'count' => 0, 'color' => 'text-gray-500'],
                    ['icon' => 'fa-random', 'label' => 'Branch Shift', 'count' => 0, 'color' => 'text-gray-500'],
                    ['icon' => 'fa-ban', 'label' => 'Cancelled', 'count' => 0, 'color' => 'text-red-500'],
                    ['icon' => 'fa-search-minus', 'label' => 'Lost', 'count' => 0, 'color' => 'text-red-500'],
                    ['icon' => 'fa-user-secret', 'label' => 'Stolen', 'count' => 0, 'color' => 'text-red-500'],
                    ['icon' => 'fa-heart-broken', 'label' => 'Damaged', 'count' => 0, 'color' => 'text-red-500'],
                ];
            ?>
            <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="p-2">
                <div class="flex justify-center items-center h-12 w-12 mx-auto rounded-full bg-gray-100 <?php echo e($status['color']); ?>">
                    <i class="fas <?php echo e($status['icon']); ?> fa-lg"></i>
                </div>
                <p class="mt-2 font-bold text-lg"><?php echo e($status['count']); ?></p>
                <p class="text-xs text-gray-500"><?php echo e($status['label']); ?></p>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <div class="lg:col-span-2 bg-white p-6 rounded-lg shadow-sm">
            <div class="flex justify-between items-center mb-4">
                <h2 class="text-lg font-semibold text-gray-800">Recent Orders</h2>
                <a href="<?php echo e(route('seller.orders.index')); ?>" class="text-sm text-blue-600">View All</a>
            </div>
            <div class="overflow-x-auto">
                <table class="min-w-full">
                    <thead>
                        <tr>
                            <th class="text-left py-2 text-sm font-medium text-gray-500">Order ID</th>
                            <th class="text-left py-2 text-sm font-medium text-gray-500">Customer</th>
                            <th class="text-left py-2 text-sm font-medium text-gray-500">City</th>
                            <th class="text-left py-2 text-sm font-medium text-gray-500">Amount</th>
                            <th class="text-left py-2 text-sm font-medium text-gray-500">Status</th>
                            <th class="text-left py-2 text-sm font-medium text-gray-500">Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $recentParcels ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parcel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td class="py-2 text-sm text-gray-700"><?php echo e($parcel->tracking_id); ?></td>
                            <td class="py-2 text-sm text-gray-700"><?php echo e($parcel->recipient_name); ?></td>
                            <td class="py-2 text-sm text-gray-700"><?php echo e($parcel->recipient_city); ?></td>
                            <td class="py-2 text-sm text-gray-700">PKR <?php echo e(number_format($parcel->cod_amount, 2)); ?></td>
                            <td class="py-2 text-sm"><span class="px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800"><?php echo e($parcel->status); ?></span></td>
                            <td class="py-2 text-sm text-gray-500"><?php echo e($parcel->created_at->format('d M')); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="text-center py-10 text-sm text-gray-500">No recent orders found.</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <div class="space-y-6">
            <div class="bg-white p-6 rounded-lg shadow-sm">
                <div class="flex justify-between items-center mb-4">
                    <h2 class="text-lg font-semibold text-gray-800">My Complaints</h2>
                    <a href="<?php echo e(route('seller.complaints.index')); ?>" class="bg-blue-500 text-white px-3 py-1 rounded-md text-xs font-semibold hover:bg-blue-600">Create Ticket</a>
                </div>
                <div class="space-y-3">
                    <?php $__empty_1 = true; $__currentLoopData = $recentComplaints ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $complaint): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="flex justify-between items-start">
                        <div>
                            <p class="text-sm font-medium text-gray-800"><?php echo e($complaint->subject); ?></p>
                            <p class="text-xs text-gray-500 truncate"><?php echo e($complaint->description); ?></p>
                        </div>
                        <span class="text-xs font-bold text-red-500">1</span>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <p class="text-sm text-gray-500">No open complaints.</p>
                    <?php endif; ?>
                </div>
            </div>
            <div class="bg-white p-6 rounded-lg shadow-sm">
                <h2 class="text-lg font-semibold text-gray-800 mb-4">Earnings</h2>
                <div class="h-40 bg-gray-200 rounded-md flex items-center justify-center">
                    <p class="text-sm text-gray-500">Earnings chart placeholder</p>
                </div>
            </div>
        </div>
    </div>
</form>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.seller', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/seller/dashboard.blade.php ENDPATH**/ ?>