

<?php $__env->startSection('title', 'Discrepancy Alerts'); ?>

<?php $__env->startSection('content'); ?>
<div class="p-6 lg:p-8" x-data="{ showModal: false }" @open-modal.window="showModal = true">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Discrepancy Alerts</h1>
            <p class="text-sm text-gray-600">Review alerts and create manual flags.</p>
        </div>
        <button @click="showModal = true" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">New Alert</button>
    </div>

    <!-- Filters -->
    <form method="GET" action="<?php echo e(url('finance/banking.discrepancies')); ?>" class="bg-white rounded-lg shadow-md p-4 mb-6 grid grid-cols-1 md:grid-cols-4 gap-4">
        <select name="status" class="form-select">
            <option value="">All</option>
            <option value="resolved" <?php echo e(request('status')==='resolved' ? 'selected' : ''); ?>>Resolved</option>
            <option value="open" <?php echo e(request('status')==='open' ? 'selected' : ''); ?>>Open</option>
        </select>
        <button class="bg-gray-800 text-white px-4 py-2 rounded-md" type="submit">Apply</button>
    </form>

    <!-- Alerts Table -->
    <div class="bg-white rounded-lg shadow-md">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Date</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Description</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Amount</th>
                        <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase">Status</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__empty_1 = true; $__currentLoopData = $alerts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td class="px-6 py-4"><?php echo e($a->txn_date?->format('M d, Y') ?? '-'); ?></td>
                            <td class="px-6 py-4"><?php echo e($a->description); ?></td>
                            <td class="px-6 py-4 text-right"><?php echo e(number_format($a->amount,2)); ?></td>
                            <td class="px-6 py-4 text-center">
                                <span class="px-2 py-1 text-xs rounded-full <?php echo e($a->resolved ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800'); ?>"><?php echo e($a->resolved ? 'Resolved' : 'Open'); ?></span>
                            </td>
                            <td class="px-6 py-4 text-right">
                                <?php if(!$a->resolved): ?>
                                <form action="<?php echo e(url('finance/banking.discrepancies.resolve', $a)); ?>" method="POST" class="inline-flex items-center space-x-2">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>
                                    <input type="text" name="resolution_notes" placeholder="Notes" class="form-input text-sm" />
                                    <button type="submit" class="text-indigo-600 hover:text-indigo-900">Resolve</button>
                                </form>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr><td colspan="5" class="text-center py-10 text-gray-500">No discrepancy alerts.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <div class="p-4"><?php echo e($alerts->appends(request()->query())->links()); ?></div>
    </div>

    <!-- New Alert Modal -->
    <div x-show="showModal" @click.away="showModal = false" class="fixed inset-0 bg-gray-600 bg-opacity-50 h-full w-full z-50" x-cloak>
        <div class="relative top-10 mx-auto p-5 border w-full max-w-xl shadow-lg rounded-md bg-white">
            <form action="<?php echo e(url('finance/banking.discrepancies.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <h3 class="text-lg font-semibold mb-4">Create Discrepancy</h3>
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm">Source</label>
                        <select name="source" class="form-select" required>
                            <option value="bank">Bank</option>
                            <option value="ledger">Ledger</option>
                            <option value="manual">Manual</option>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm">Date</label>
                        <input type="date" name="txn_date" class="form-input">
                    </div>
                    <div>
                        <label class="block text-sm">Description</label>
                        <input type="text" name="description" class="form-input" required>
                    </div>
                    <div>
                        <label class="block text-sm">Amount</label>
                        <input type="number" name="amount" step="0.01" class="form-input" required>
                    </div>
                </div>
                <div class="flex justify-end space-x-2 mt-6">
                    <button type="button" @click="showModal = false" class="bg-gray-300 text-gray-700 px-4 py-2 rounded-lg">Close</button>
                    <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Save Alert</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/admin/finance/banking/discrepancies.blade.php ENDPATH**/ ?>