<?php
$sellerMenuGroups = [
    [
        'title' => 'MANAGE ORDERS',
        'items' => [
            ['href' => 'seller.orders.create', 'label' => 'Create Order', 'icon' => 'fa-plus-circle'],
            ['href' => 'seller.orders.index', 'label' => 'Cancel Order', 'icon' => 'fa-ban'],
            ['href' => 'seller.orders.transit', 'label' => 'Transit Orders', 'icon' => 'fa-truck'],
            ['href' => 'seller.orders.verification', 'label' => 'Under Verification', 'icon' => 'fa-shield-alt'],
            ['href' => 'seller.orders.logs', 'label' => 'Order Logs', 'icon' => 'fa-book'],
            ['href' => 'seller.orders.airway-bills', 'label' => 'Airway Bills', 'icon' => 'fa-file-alt'],
            ['href' => 'seller.orders.bulk-upload', 'label' => 'Bulk Upload', 'icon' => 'fa-cloud-upload-alt'],
            ['href' => 'seller.complaints.index', 'label' => 'My Complaints', 'icon' => 'fa-comment-dots'],
        ]
    ],
    [
        'title' => 'LOAD SHEET',
        'items' => [
            ['href' => 'seller.load-sheet.create', 'label' => 'Generate Load Sheet', 'icon' => 'fa-file-spreadsheet'],
            ['href' => 'seller.load-sheet.index', 'label' => 'Load Sheet Logs', 'icon' => 'fa-history'],
        ]
    ],
    [
        'title' => 'PAYMENTS',
        'items' => [
            ['href' => 'seller.payments.receipt', 'label' => 'Cash Payment Receipt', 'icon' => 'fa-receipt'],
            ['href' => 'seller.payments.settlements', 'label' => 'Settlement Logs', 'icon' => 'fa-wallet'],
            ['href' => 'seller.payments.invoices', 'label' => 'Tax Invoices', 'icon' => 'fa-file-invoice-dollar'],
        ]
    ],
    [
        'title' => 'PACKAGING',
        'items' => [
            ['href' => 'seller.packaging.create', 'label' => 'New Request', 'icon' => 'fa-plus-square'],
            ['href' => 'seller.packaging.index', 'label' => 'Packaging Logs', 'icon' => 'fa-box-open'],
        ]
    ],
    [
        'title' => 'REPORTS',
        'items' => [
            ['href' => 'seller.reports.orders', 'label' => 'Monthly/Weekly Order Wise', 'icon' => 'fa-chart-line'],
            ['href' => 'seller.reports.amounts', 'label' => 'Monthly/Weekly Amount Wise', 'icon' => 'fa-chart-bar'],
            ['href' => 'seller.reports.status', 'label' => 'Order Status Report', 'icon' => 'fa-tasks'],
            ['href' => 'seller.reports.instock', 'label' => 'InStock Report', 'icon' => 'fa-boxes'],
            ['href' => 'seller.reports.pickup', 'label' => 'Pickup Report', 'icon' => 'fa-truck-loading'],
            ['href' => 'seller.reports.destination', 'label' => 'Destination City Wise', 'icon' => 'fa-map-marked-alt'],
            ['href' => 'seller.reports.complaints', 'label' => 'Complaint Details', 'icon' => 'fa-exclamation-circle'],
        ]
    ],
    [
        'title' => 'OTHERS',
        'items' => [
            ['href' => 'seller.others.integrations', 'label' => 'Integrations', 'icon' => 'fa-cogs'],
            ['href' => 'seller.others.mobile-app', 'label' => 'Mobile App', 'icon' => 'fa-mobile-alt'],
            ['href' => 'seller.others.news', 'label' => 'Company News', 'icon' => 'fa-newspaper'],
        ]
    ]
];
?>

<div class="flex h-full max-h-screen flex-col">
        <div class="flex-1 overflow-y-auto">
            <nav class="grid items-start p-2 text-sm font-medium pb-12">
                <?php $__currentLoopData = $sellerMenuGroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="mb-1 px-2">
                    <h3 class="px-3 py-2 font-semibold text-blue-600 uppercase text-xs tracking-wider"><?php echo e($group['title']); ?></h3>
                    <div class="flex flex-col gap-1">
                        <?php $__currentLoopData = $group['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(route($item['href'])); ?>" 
                               class="flex items-center gap-3 rounded-md px-3 py-2 text-gray-600 transition-all hover:text-blue-600 hover:bg-blue-50 <?php echo e(request()->routeIs($item['href']) ? 'bg-blue-100 text-blue-700 font-semibold' : ''); ?>">
                                <i class="fas <?php echo e($item['icon']); ?> h-5 w-5"></i>
                                <span class="flex-1"><?php echo e($item['label']); ?></span>
                            </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </nav>
        </div>
    </div>
<?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/partials/seller-sidebar.blade.php ENDPATH**/ ?>