

<?php $__env->startSection('title', 'Cancel Order'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-white p-6 rounded-lg shadow-md">
    <div class="flex justify-between items-center mb-4">
        <h2 class="text-xl font-bold text-gray-800">Cancel order</h2>
    </div>

    <div class="border-b border-gray-200">
        <nav class="-mb-px flex space-x-6">
            <a href="<?php echo e(route('seller.orders.index')); ?>" class="py-4 px-1 border-b-2 <?php echo e(request('tab') == '' ? 'border-blue-500 text-blue-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'); ?> font-medium text-sm">All (<?php echo e($allCount); ?>)</a>
            <a href="<?php echo e(route('seller.orders.index', ['tab' => 'booked'])); ?>" class="py-4 px-1 border-b-2 <?php echo e(request('tab') == 'booked' ? 'border-blue-500 text-blue-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'); ?> font-medium text-sm">Booked (<?php echo e($bookedCount); ?>)</a>
            <a href="<?php echo e(route('seller.orders.index', ['tab' => 'unbooked'])); ?>" class="py-4 px-1 border-b-2 <?php echo e(request('tab') == 'unbooked' ? 'border-blue-500 text-blue-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'); ?> font-medium text-sm">Unbooked (<?php echo e($unbookedCount); ?>)</a>
            <a href="<?php echo e(route('seller.orders.index', ['tab' => 'logs'])); ?>" class="py-4 px-1 border-b-2 <?php echo e(request('tab') == 'logs' ? 'border-blue-500 text-blue-600' : 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300'); ?> font-medium text-sm">Logs (<?php echo e($logsCount); ?>)</a>
        </nav>
    </div>

    <div class="mt-6">
        <h3 class="text-lg font-medium text-gray-900 mb-4">ADVANCED SEARCH</h3>
        <form action="<?php echo e(route('seller.orders.index')); ?>" method="GET" class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <input type="hidden" name="tab" value="<?php echo e(request('tab')); ?>">
            <div>
                <label for="search" class="block text-sm font-medium text-gray-700">Search by</label>
                <input type="text" name="search" id="search" value="<?php echo e(request('search')); ?>" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm" placeholder="Order #, Customer...">
            </div>
            <div>
                <label for="from_date" class="block text-sm font-medium text-gray-700">From</label>
                <input type="date" name="from_date" id="from_date" value="<?php echo e(request('from_date')); ?>" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm">
            </div>
            <div>
                <label for="to_date" class="block text-sm font-medium text-gray-700">To</label>
                <input type="date" name="to_date" id="to_date" value="<?php echo e(request('to_date')); ?>" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm">
            </div>
            <div class="md:col-span-3 flex justify-start gap-2">
                <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-md font-semibold">Search</button>
                <a href="<?php echo e(route('seller.orders.index', ['tab' => request('tab')])); ?>" class="bg-gray-200 text-gray-700 px-4 py-2 rounded-md font-semibold">Clear Filter</a>
            </div>
        </form>
    </div>

    <div class="mt-8 overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead>
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Order Ref #</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Tracking #</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Customer</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Delivery Address</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Amount</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Action</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo e($order->order_ref ?? 'N/A'); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-blue-600"><?php echo e($order->tracking_id); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo e($order->recipient_name); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo e($order->recipient_address); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">PKR <?php echo e(number_format($order->cod_amount, 2)); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-blue-100 text-blue-800"><?php echo e($order->status); ?></span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                        <?php if($order->trashed()): ?>
                        <span class="text-gray-400">Cancelled</span>
                        <?php else: ?>
                        <form action="<?php echo e(route('seller.orders.destroy', $order)); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="text-red-600 hover:text-red-900">Cancel</button>
                        </form>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="7" class="text-center py-10 text-sm text-gray-500">No orders available.</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
        <div class="mt-4">
            <?php echo e($orders->appends(request()->query())->links()); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.seller', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/seller/orders/index.blade.php ENDPATH**/ ?>