

<?php $__env->startSection('title', 'Payment Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-6">
<a href="<?php echo e(route('finance.settlements.payments.index')); ?>" class="text-blue-600">← Back to Payments</a>

    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6 mt-4">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900 mb-4 sm:mb-6">Payment #<?php echo e($payment->payment_number ?? $payment->id); ?></h1>
        <div class="grid grid-cols-1 sm:grid-cols-2 gap-3 sm:gap-4 text-sm">
            <div>
                <p class="text-gray-500">Merchant</p>
                <p class="text-gray-900"><?php echo e($payment->merchant->name ?? '-'); ?> (<?php echo e($payment->merchant->company_name ?? ''); ?>)</p>
            </div>
            <div>
                <p class="text-gray-500">Amount</p>
                <p class="text-gray-900"><?php echo e(number_format($payment->amount, 2)); ?></p>
            </div>
            <div>
                <p class="text-gray-500">Payment Date</p>
                <p class="text-gray-900"><?php echo e(optional($payment->payment_date)->format('Y-m-d')); ?></p>
            </div>
            <div>
                <p class="text-gray-500">Method</p>
                <p class="text-gray-900"><?php echo e(ucwords(str_replace('_',' ', $payment->payment_method))); ?></p>
            </div>
            <div>
                <p class="text-gray-500">Reference</p>
                <p class="text-gray-900"><?php echo e($payment->reference_number ?? '-'); ?></p>
            </div>
            <div>
                <p class="text-gray-500">Status</p>
                <p>
                    <span class="px-2 inline-flex text-[10px] leading-4 font-semibold rounded-full <?php echo e($payment->status === 'completed' ? 'bg-green-100 text-green-800' : ($payment->status === 'pending' ? 'bg-yellow-100 text-yellow-800' : 'bg-gray-100 text-gray-800')); ?>">
                        <?php echo e(ucfirst($payment->status)); ?>

                    </span>
                </p>
            </div>
            <div class="sm:col-span-2">
                <p class="text-gray-500">Notes</p>
                <p class="text-gray-900"><?php echo e($payment->notes ?? '-'); ?></p>
            </div>
        </div>

        <div class="mt-6 flex gap-2 sm:gap-3">
            <a href="<?php echo e(route('finance.settlements.payments.edit', $payment)); ?>" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Edit</a>
            <form method="POST" action="<?php echo e(route('finance.settlements.payments.destroy', $payment)); ?>" onsubmit="return confirm('Delete this payment?')">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button type="submit" class="bg-red-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-red-700 transition">Delete</button>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/admin/finance/settlements/payments/show.blade.php ENDPATH**/ ?>