<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('title', 'Admin - Al-wasi Soft Tech CMS'); ?></title>
    <script src="https://cdn.tailwindcss.com?plugins=forms,typography"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" />
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; }
        #sidebar-toggle { display: none; }

        #sidebar {
            transform: translateX(-100%);
            transition: transform 0.3s ease-in-out;
        }

        /* When checkbox is checked, affect elements inside the layout container */
        #sidebar-toggle:checked ~ #layout #sidebar {
            transform: translateX(0);
        }

        #sidebar-toggle:checked ~ #layout #mobile-overlay {
            display: block;
        }

        @media (min-width: 1024px) {
            #sidebar {
                transform: translateX(0);
            }
            main {
                margin-left: 14rem; /* 224px */
            }
            label[for="sidebar-toggle"], #mobile-overlay {
                display: none;
            }
        }
        [x-cloak] { display: none !important; }
    </style>
    <!-- Removed broken asset links to non-existent next/css files -->
    <!-- Tailwind CDN and Font Awesome already provide necessary styles -->
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body class="bg-gray-100">
    <input type="checkbox" id="sidebar-toggle" class="hidden">

    <!-- Top Navigation -->
    <nav class="bg-white shadow-sm border-b fixed top-0 left-0 right-0 z-30">
        <div class="px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between h-16">
                <div class="flex items-center">
                    <label for="sidebar-toggle" class="text-gray-500 hover:text-gray-700 p-2 cursor-pointer lg:hidden">
                        <svg class="h-6 w-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"/>
                        </svg>
                    </label>
                    
                    <a href="<?php echo e(route('home')); ?>" class="flex items-center ml-4">
                        <svg class="h-8 w-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"/>
                        </svg>
                        <span class="ml-2 text-xl font-bold text-gray-900 hidden sm:inline">Al-wasi Soft Tech</span>
                    </a>
                </div>

                <div class="flex items-center space-x-2 sm:space-x-4">
                    <span class="text-xs sm:text-sm text-gray-700 hidden sm:inline"><?php echo e(auth()->user()->name); ?></span>
                    <span class="px-2 py-1 text-xs font-semibold rounded-full bg-blue-100 text-blue-800">
                        <?php echo e(ucwords(str_replace('-', ' ', auth()->user()->role))); ?>

                    </span>
                    <form method="POST" action="<?php echo e(route('logout')); ?>" class="inline">
                        <?php echo csrf_field(); ?>
                        <button type="submit" class="bg-red-600 text-white px-3 py-2 sm:px-4 rounded-md text-xs sm:text-sm font-medium hover:bg-red-700">
                            Logout
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </nav>

    <div id="layout" class="flex pt-16">
        <label for="sidebar-toggle" id="mobile-overlay" class="fixed inset-0 bg-black/30 z-10 hidden lg:hidden"></label>
        
        <?php if(auth()->user()->hasRole('Finance')): ?>
    <?php echo $__env->make('partials.finance-sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php elseif(auth()->user()->hasRole('Branch Operator')): ?>
    <?php echo $__env->make('partials.branch-sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php else: ?>
    <?php echo $__env->make('partials.new-admin-sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php endif; ?>

        <main class="flex-1 overflow-auto bg-gray-50 transition-all duration-300">
            <?php if(session('success')): ?>
                <div class="m-4">
                    <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative" role="alert">
                        <span class="block sm:inline"><?php echo e(session('success')); ?></span>
                    </div>
                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="m-4">
                    <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative" role="alert">
                        <span class="block sm:inline"><?php echo e(session('error')); ?></span>
                    </div>
                </div>
            <?php endif; ?>

            <?php echo $__env->yieldContent('content'); ?>
        </main>
    </div>
    
    <?php echo $__env->yieldPushContent('scripts'); ?>

</body>
</html>
<?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/layouts/admin.blade.php ENDPATH**/ ?>