<?php $__env->startSection('title', 'Receive Shipments'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 sm:px-6 lg:px-8 py-4">
    <div class="flex justify-between items-center mb-4">
        <h1 class="text-2xl font-bold text-gray-800 flex items-center">
            <i class="fa-regular fa-dolly mr-2"></i> Receive Shipments
        </h1>
    </div>

    <div class="bg-white p-6 rounded-lg shadow-sm">
        <h2 class="text-lg font-semibold text-gray-900">Scan Shipments</h2>
        <p class="mt-1 text-sm text-gray-600">Scan incoming shipments to mark them as received at the branch.</p>

        <div class="mt-4">
            <!-- Receive shipments functionality will go here -->
            <form id="scan-shipment-form" class="mt-4 flex items-center space-x-3">
                <div class="relative flex-grow">
                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                        <i class="fa-regular fa-barcode-read text-gray-400"></i>
                    </div>
                    <input type="text" id="tracking_id" name="tracking_id" class="block w-full pl-10 pr-3 py-2 border border-gray-300 rounded-md leading-5 bg-white placeholder-gray-500 focus:outline-none focus:placeholder-gray-400 focus:ring-1 focus:ring-blue-500 focus:border-blue-500 sm:text-sm" placeholder="Scan or enter tracking ID..." autocomplete="off">
                </div>
                <button type="submit" class="inline-flex items-center justify-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                    <i class="fa-regular fa-check mr-2"></i> Mark as Received
                </button>
            </form>

            <div id="scanned-parcels-container" class="mt-6">
                <!-- Scanned parcel details will be injected here -->
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const form = document.getElementById('scan-shipment-form');
        const trackingIdInput = document.getElementById('tracking_id');
        const scannedParcelsContainer = document.getElementById('scanned-parcels-container');

        form.addEventListener('submit', function (e) {
            e.preventDefault();
            const trackingId = trackingIdInput.value;

            if (trackingId) {
                fetch('<?php echo e(route("branch.receive-shipments.scan")); ?>', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                    },
                    body: JSON.stringify({ 
                        tracking_id: trackingId 
                    })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        trackingIdInput.value = ''; // Clear input
                        addParcelToView(data.parcel);
                    } else {
                        // Handle error
                        alert(data.message || 'An error occurred.');
                    }
                })
                .catch(error => console.error('Error:', error));
            }
        });

        function addParcelToView(parcel) {
            const parcelDiv = document.createElement('div');
            parcelDiv.classList.add('p-4', 'mb-4', 'border', 'rounded-md', 'bg-green-50');
            parcelDiv.innerHTML = `
                <p class="font-semibold text-green-800">Successfully Received: ${parcel.tracking_id}</p>
                <p class="text-sm text-gray-600">Recipient: ${parcel.recipient_name}</p>
            `;
            scannedParcelsContainer.prepend(parcelDiv);
        }
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/branch/receive-shipments.blade.php ENDPATH**/ ?>