

<?php $__env->startSection('content'); ?>
<div class="p-6">
    <div class="flex justify-between items-center mb-4">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-semibold">Pricing Rates</h1>
        <a href="<?php echo e(route('admin.marketing.rates.pricing.create')); ?>" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Add Rate</a>
    </div>

    <form method="GET" class="mb-4 grid grid-cols-1 md:grid-cols-4 gap-3">
        <input type="text" name="q" value="<?php echo e(request('q')); ?>" placeholder="Search name/code/zone/currency" class="border rounded px-3 py-2" />
        <select name="status" class="border rounded px-3 py-2">
            <option value="">All Status</option>
            <?php $__currentLoopData = ['draft','active','expired','archived']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $st): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($st); ?>" <?php echo e(request('status')===$st ? 'selected' : ''); ?>><?php echo e(ucfirst($st)); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
        <input type="text" name="zone" value="<?php echo e(request('zone')); ?>" placeholder="Zone" class="border rounded px-3 py-2" />
        <button class="px-4 py-2 bg-gray-700 text-white rounded">Filter</button>
    </form>

    <?php if(session('success')): ?>
        <div class="mb-3 p-3 bg-green-50 border border-green-200 rounded text-green-700"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <div class="overflow-x-auto bg-white rounded border">
        <table class="min-w-full">
            <thead>
                <tr class="border-b">
                    <th class="text-left p-2">Name</th>
                    <th class="text-left p-2">Code</th>
                    <th class="text-left p-2">Currency</th>
                    <th class="text-left p-2">Base</th>
                    <th class="text-left p-2">Per KG</th>
                    <th class="text-left p-2">Per KM</th>
                    <th class="text-left p-2">Zone</th>
                    <th class="text-left p-2">Effective</th>
                    <th class="text-left p-2">Status</th>
                    <th class="text-left p-2">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $pricings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pricing): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr class="border-b">
                    <td class="p-2"><?php echo e($pricing->name); ?></td>
                    <td class="p-2"><?php echo e($pricing->code); ?></td>
                    <td class="p-2"><?php echo e($pricing->currency); ?></td>
                    <td class="p-2"><?php echo e(number_format($pricing->base_rate,2)); ?></td>
                    <td class="p-2"><?php echo e($pricing->per_kg_rate ? number_format($pricing->per_kg_rate,2) : '-'); ?></td>
                    <td class="p-2"><?php echo e($pricing->per_km_rate ? number_format($pricing->per_km_rate,2) : '-'); ?></td>
                    <td class="p-2"><?php echo e($pricing->zone ?: '-'); ?></td>
                    <td class="p-2"><?php echo e($pricing->effective_from->format('Y-m-d')); ?><?php echo e($pricing->effective_to ? ' to '.$pricing->effective_to->format('Y-m-d') : ''); ?></td>
                    <td class="p-2"><span class="px-2 py-1 text-xs rounded bg-gray-100"><?php echo e(ucfirst($pricing->status)); ?></span></td>
                    <td class="p-2 space-x-2">
                        <a href="<?php echo e(route('admin.marketing.rates.pricing.show', $pricing)); ?>" class="text-blue-600">View</a>
                        <a href="<?php echo e(route('admin.marketing.rates.pricing.edit', $pricing)); ?>" class="text-indigo-600">Edit</a>
                        <form action="<?php echo e(route('admin.marketing.rates.pricing.destroy', $pricing)); ?>" method="POST" class="inline">
                            <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                            <button onclick="return confirm('Delete this rate?')" class="text-red-600">Delete</button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="10" class="p-4 text-center text-gray-500">No pricing rates found.</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <div class="mt-4"><?php echo e($pricings->links()); ?></div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/admin/marketing/rates/pricing/index.blade.php ENDPATH**/ ?>