

<?php $__env->startSection('title', 'Access Controls'); ?>

<?php $__env->startSection('content'); ?>
<div class="p-6 lg:p-8" x-data="{ showModal: false }" @open-modal.window="showModal = true">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Access Controls</h1>
            <p class="text-sm text-gray-600">Manage system access permissions and reviews.</p>
        </div>
        <button @click="showModal = true" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">New Control</button>
    </div>

    <!-- Access Controls Table -->
    <div class="bg-white rounded-lg shadow-md">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Title</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Owner</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Review Date</th>
                        <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase">Status</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__empty_1 = true; $__currentLoopData = $accessControls; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $control): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td class="px-6 py-4"><?php echo e($control->title); ?></td>
                            <td class="px-6 py-4"><?php echo e($control->owner ?? '-'); ?></td>
                            <td class="px-6 py-4"><?php echo e($control->review_date?->format('M d, Y') ?? '-'); ?></td>
                            <td class="px-6 py-4 text-center">
                                <span class="px-2 py-1 text-xs rounded-full <?php echo e($control->status==='active' ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800'); ?>"><?php echo e(ucfirst($control->status)); ?></span>
                            </td>
                            <td class="px-6 py-4 text-right">
                                <form action="<?php echo e(url('finance/audit.access-controls.update', $control)); ?>" method="POST" class="inline-flex items-center space-x-2">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>
                                    <select name="status" class="form-select text-sm">
                                        <?php $__currentLoopData = ['active','inactive']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($s); ?>" <?php echo e($control->status===$s ? 'selected' : ''); ?>><?php echo e(ucfirst($s)); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <button class="text-indigo-600 hover:text-indigo-900">Update</button>
                                </form>
                                <form action="<?php echo e(url('finance/audit.access-controls.destroy', $control)); ?>" method="POST" class="inline" onsubmit="return confirm('Delete control?')">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button class="text-red-600 hover:text-red-900 ml-3">Delete</button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr><td colspan="5" class="text-center py-10 text-gray-500">No access controls found.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <div class="p-4"><?php echo e($accessControls->links()); ?></div>
    </div>

    <!-- New Control Modal -->
    <div x-show="showModal" @click.away="showModal = false" class="fixed inset-0 bg-gray-600 bg-opacity-50 h-full w-full z-50" x-cloak>
        <div class="relative top-10 mx-auto p-5 border w-full max-w-xl shadow-lg rounded-md bg-white">
            <form action="<?php echo e(url('finance/audit.access-controls.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <h3 class="text-lg font-semibold mb-4">Create Access Control</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm">Title</label>
                        <input type="text" name="title" class="form-input" required placeholder="e.g., Admin Panel Access">
                    </div>
                    <div>
                        <label class="block text-sm">Owner</label>
                        <input type="text" name="owner" class="form-input" placeholder="Responsible person/department">
                    </div>
                    <div>
                        <label class="block text-sm">Review Date</label>
                        <input type="date" name="review_date" class="form-input">
                    </div>
                    <div class="md:col-span-2">
                        <label class="block text-sm">Notes</label>
                        <textarea name="notes" rows="2" class="form-input" placeholder="Additional details or restrictions..."></textarea>
                    </div>
                </div>
                <div class="flex justify-end space-x-2 mt-6">
                    <button type="button" @click="showModal = false" class="bg-gray-300 text-gray-700 px-4 py-2 rounded-lg">Close</button>
                    <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Create</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/admin/finance/audit/access-controls.blade.php ENDPATH**/ ?>