

<?php $__env->startSection('title', $title); ?>

<?php $__env->startSection('content'); ?>
<div class="p-6 lg:p-8" x-data="{ showModal: false }">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800"><?php echo e($title); ?></h1>
            <p class="text-sm text-gray-600">Manage all <?php echo e(strtolower($title)); ?>.</p>
        </div>
        <button @click="showModal = true" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Add New Voucher</button>
    </div>

    <div class="bg-white rounded-lg shadow-md">
        <div class="p-4 border-b">
            <h3 class="text-lg font-semibold">All Vouchers</h3>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Voucher #</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Date</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Description</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Amount</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__empty_1 = true; $__currentLoopData = $vouchers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $voucher): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td class="px-6 py-4 text-sm font-medium"><?php echo e($voucher->voucher_number); ?></td>
                            <td class="px-6 py-4 text-sm"><?php echo e($voucher->voucher_date->format('d M, Y')); ?></td>
                            <td class="px-6 py-4 text-sm"><?php echo e($voucher->description); ?></td>
                            <td class="px-6 py-4 text-sm">Rs. <?php echo e(number_format($voucher->amount, 2)); ?></td>
                            <td class="px-6 py-4 text-sm">
                                <a href="<?php echo e(url('finance/vouchers.edit', $voucher)); ?>" class="text-indigo-600 hover:text-indigo-900">Edit</a>
                                <form action="<?php echo e(url('finance/vouchers.destroy', $voucher)); ?>" method="POST" class="inline" onsubmit="return confirm('Are you sure?')">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="text-red-600 hover:text-red-900 ml-2">Delete</button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="5" class="text-center py-10">No vouchers found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <div class="p-4"><?php echo e($vouchers->links()); ?></div>
    </div>

    <!-- Add Voucher Modal -->
    <div x-show="showModal" @click.away="showModal = false" class="fixed inset-0 bg-gray-600 bg-opacity-50 h-full w-full z-50" x-cloak>
        <div class="relative top-20 mx-auto p-5 border w-full max-w-lg shadow-lg rounded-md bg-white">
            <h3 class="text-lg font-semibold mb-4">Add New Voucher</h3>
            <form action="<?php echo e(url('finance/vouchers.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="type" value="<?php echo e($type); ?>">
                <div class="space-y-4">
                    <div>
                        <label class="block text-xs sm:text-sm font-medium text-gray-700">Voucher Date</label>
                        <input type="date" name="voucher_date" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required>
                    </div>
                    <div>
                        <label class="block text-xs sm:text-sm font-medium text-gray-700">Description</label>
                        <textarea name="description" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" required></textarea>
                    </div>
                    <div>
                        <label class="block text-xs sm:text-sm font-medium text-gray-700">Amount</label>
                        <input type="number" name="amount" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm" step="0.01" required>
                    </div>
                </div>
                <div class="flex justify-end space-x-2 mt-6">
                    <button type="button" @click="showModal = false" class="bg-gray-300 text-gray-700 px-4 py-2 rounded-lg hover:bg-gray-400">Close</button>
                    <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Save Voucher</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/admin/finance/vouchers/index.blade.php ENDPATH**/ ?>