

<?php $__env->startSection('title', 'Load Sheet Logs'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-white p-6 rounded-lg shadow-md">
    <div class="flex items-center justify-end gap-2 mb-4">
        <button class="bg-gray-200 text-gray-700 p-2 rounded-md"><i class="fas fa-sync-alt"></i></button>
        <button class="bg-gray-200 text-gray-700 p-2 rounded-md"><i class="fas fa-cloud-upload-alt"></i></button>
        <button class="bg-gray-200 text-gray-700 p-2 rounded-md"><i class="fas fa-download"></i></button>
        <button class="bg-gray-200 text-gray-700 p-2 rounded-md"><i class="fas fa-print"></i></button>
        <button class="bg-gray-200 text-gray-700 p-2 rounded-md"><i class="fas fa-cog"></i></button>
    </div>

    <div class="p-4 border rounded-lg bg-gray-50 mb-6">
        <p class="text-sm font-semibold mb-4 text-gray-500">ADVANCED SEARCH</p>
        <form action="<?php echo e(route('seller.load-sheet.index')); ?>" method="GET" class="flex flex-wrap items-end gap-4">
            <div class="flex-1 min-w-[300px]">
                <label class="text-xs text-gray-500">Search by</label>
                <div class="flex">
                    <input type="text" name="search" value="<?php echo e(request('search')); ?>" placeholder="Search..." class="w-full border-gray-300 rounded-l-md shadow-sm">
                    <select name="search_type" class="w-auto border-gray-300 rounded-r-md shadow-sm border-l-0">
                        <option value="id" <?php if(request('search_type') == 'id'): echo 'selected'; endif; ?>>LOADSHEET #</option>
                        <option value="rider_name" <?php if(request('search_type') == 'rider_name'): echo 'selected'; endif; ?>>RIDER</option>
                    </select>
                </div>
            </div>
            <div class="flex items-center gap-2">
                <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-md font-semibold"><i class="fas fa-search mr-2"></i> Search</button>
                <a href="<?php echo e(route('seller.load-sheet.index')); ?>" class="bg-gray-200 text-gray-700 px-4 py-2 rounded-md font-semibold">Clear Filter</a>
            </div>
        </form>
    </div>

    <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead>
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Loadsheet #</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Total Orders</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Rider Name</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Action</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php $__empty_1 = true; $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-blue-600">LS-<?php echo e($log->id); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo e($log->orders_count); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo e($log->rider_name); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo e($log->load_sheet_date); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">
                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800"><?php echo e($log->status); ?></span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                        <a href="#" class="text-blue-600 hover:text-blue-900">Download</a>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="6" class="text-center py-10 text-sm text-gray-500">No load sheet logs found.</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
        <div class="mt-4">
            <?php echo e($logs->appends(request()->query())->links()); ?>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.seller', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/seller/load-sheet/index.blade.php ENDPATH**/ ?>