

<?php $__env->startSection('title', 'Cheque Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="p-6 lg:p-8" x-data="{ showModal: false }" @open-modal.window="showModal = true">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Cheque Management</h1>
            <p class="text-sm text-gray-600">Track all incoming and outgoing cheques.</p>
        </div>
        <button @click="showModal = true" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Add Cheque</button>
    </div>

    <!-- Filters -->
    <form method="GET" action="<?php echo e(url('finance/banking.cheques')); ?>" class="bg-white rounded-lg shadow-md p-4 mb-6 grid grid-cols-1 md:grid-cols-4 gap-4">
        <select name="type" class="form-select">
            <option value="">All Types</option>
            <?php $__currentLoopData = ['incoming','outgoing']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($t); ?>" <?php echo e(request('type')===$t ? 'selected' : ''); ?>><?php echo e(ucfirst($t)); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
        <select name="status" class="form-select">
            <option value="">All Status</option>
            <?php $__currentLoopData = ['issued','deposited','cleared','bounced','cancelled']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($s); ?>" <?php echo e(request('status')===$s ? 'selected' : ''); ?>><?php echo e(ucfirst($s)); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
        <select name="bank_account_id" class="form-select">
            <option value="">All Accounts</option>
            <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $acc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($acc->id); ?>" <?php echo e(request('bank_account_id')==$acc->id ? 'selected' : ''); ?>><?php echo e($acc->bank_name); ?> - <?php echo e($acc->account_number); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
        <button type="submit" class="bg-gray-800 text-white px-4 py-2 rounded-md">Filter</button>
    </form>

    <!-- Cheques Table -->
    <div class="bg-white rounded-lg shadow-md">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Cheque #</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Type</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Payee</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Bank Account</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Issue Date</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Amount</th>
                        <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase">Status</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__empty_1 = true; $__currentLoopData = $cheques; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td class="px-6 py-4"><?php echo e($ch->cheque_number); ?></td>
                            <td class="px-6 py-4"><?php echo e(ucfirst($ch->type)); ?></td>
                            <td class="px-6 py-4"><?php echo e($ch->payee ?? '-'); ?></td>
                            <td class="px-6 py-4"><?php echo e($ch->bankAccount->bank_name ?? ''); ?> - <?php echo e($ch->bankAccount->account_number ?? ''); ?></td>
                            <td class="px-6 py-4"><?php echo e($ch->issue_date->format('M d, Y')); ?></td>
                            <td class="px-6 py-4 text-right"><?php echo e(number_format($ch->amount,2)); ?></td>
                            <td class="px-6 py-4 text-center">
                                <span class="px-2 py-1 text-xs rounded-full <?php echo e($ch->status==='cleared' ? 'bg-green-100 text-green-800' : ($ch->status==='bounced' ? 'bg-red-100 text-red-800' : 'bg-yellow-100 text-yellow-800')); ?>">
                                    <?php echo e(ucfirst($ch->status)); ?>

                                </span>
                            </td>
                            <td class="px-6 py-4 text-right">
                                <form action="<?php echo e(url('finance/banking.cheques.status', $ch)); ?>" method="POST" class="inline-flex items-center space-x-2">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>
                                    <select name="status" class="form-select text-sm">
                                        <?php $__currentLoopData = ['issued','deposited','cleared','bounced','cancelled']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($s); ?>" <?php echo e($ch->status===$s ? 'selected' : ''); ?>><?php echo e(ucfirst($s)); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <button type="submit" class="text-indigo-600 hover:text-indigo-900">Update</button>
                                </form>
                                <form action="<?php echo e(url('finance/banking.cheques.destroy', $ch)); ?>" method="POST" class="inline" onsubmit="return confirm('Delete this cheque?')">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="text-red-600 hover:text-red-900 ml-3">Delete</button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr><td colspan="8" class="text-center py-10 text-gray-500">No cheques found.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <div class="p-4"><?php echo e($cheques->appends(request()->query())->links()); ?></div>
    </div>

    <!-- Add Cheque Modal -->
    <div x-show="showModal" @click.away="showModal = false" class="fixed inset-0 bg-gray-600 bg-opacity-50 h-full w-full z-50" x-cloak>
        <div class="relative top-10 mx-auto p-5 border w-full max-w-xl shadow-lg rounded-md bg-white">
            <form action="<?php echo e(url('finance/banking.cheques.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <h3 class="text-lg font-semibold mb-4">Add Cheque</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm">Bank Account</label>
                        <select name="bank_account_id" class="form-select" required>
                            <option value="">Select Account</option>
                            <?php $__currentLoopData = $accounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $acc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($acc->id); ?>"><?php echo e($acc->bank_name); ?> - <?php echo e($acc->account_number); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm">Cheque Number</label>
                        <input type="text" name="cheque_number" class="form-input" required>
                    </div>
                    <div>
                        <label class="block text-sm">Type</label>
                        <select name="type" class="form-select" required>
                            <option value="incoming">Incoming</option>
                            <option value="outgoing">Outgoing</option>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm">Payee</label>
                        <input type="text" name="payee" class="form-input">
                    </div>
                    <div>
                        <label class="block text-sm">Amount</label>
                        <input type="number" name="amount" step="0.01" class="form-input" required>
                    </div>
                    <div>
                        <label class="block text-sm">Issue Date</label>
                        <input type="date" name="issue_date" class="form-input" required>
                    </div>
                    <div>
                        <label class="block text-sm">Due Date</label>
                        <input type="date" name="due_date" class="form-input">
                    </div>
                    <div class="md:col-span-2">
                        <label class="block text-sm">Notes</label>
                        <textarea name="notes" rows="2" class="form-input"></textarea>
                    </div>
                </div>
                <div class="flex justify-end space-x-2 mt-6">
                    <button type="button" @click="showModal = false" class="bg-gray-300 text-gray-700 px-4 py-2 rounded-lg">Close</button>
                    <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Save Cheque</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        <?php if($errors->any()): ?>
            window.dispatchEvent(new CustomEvent('open-modal'));
        <?php endif; ?>
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/admin/finance/banking/cheques.blade.php ENDPATH**/ ?>