


<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Dispatch</h1>
        <p class="text-xs sm:text-sm text-gray-600 mt-1">Assign shipments to riders, scan and print manifest.</p>
    </div>

    
    <?php if(session('success')): ?>
        <div class="mb-4 p-3 rounded bg-green-50 text-green-700 border border-green-200"><?php echo e(session('success')); ?></div>
    <?php endif; ?>
    <?php if($errors->any()): ?>
        <div class="mb-4 p-3 rounded bg-red-50 text-red-700 border border-red-200">
            <ul class="list-disc pl-5">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6 space-y-6">
        
        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <form method="GET" action="<?php echo e(route('admin.branch.dispatch')); ?>" class="flex gap-2 sm:gap-3">
                <input type="text" name="q" value="<?php echo e($q); ?>" placeholder="Search tracking, name, city, order ref"
                       class="flex-1 border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-indigo-500" />
                <button class="bg-indigo-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-indigo-700 transition">Search</button>
            </form>

            <form method="POST" action="<?php echo e(route('admin.branch.dispatch.scan')); ?>" class="flex gap-2 sm:gap-3">
                <?php echo csrf_field(); ?>
                <input type="text" name="tracking_id" placeholder="Scan/Enter Tracking ID"
                       class="flex-1 border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-indigo-500" />
                <button class="bg-slate-700 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-slate-800 transition">Scan</button>
            </form>

            <div class="flex justify-end gap-2 sm:gap-3">
                <form id="manifestForm" method="GET" action="<?php echo e(route('admin.branch.dispatch.manifest')); ?>">
                    <input type="hidden" name="parcel_ids[]" value="" />
                    <button type="button" id="btnManifest" class="bg-amber-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-amber-700 transition">Print Manifest</button>
                </form>
            </div>
        </div>

        
        <form id="assignForm" method="POST" action="<?php echo e(route('admin.branch.dispatch.assign')); ?>" class="flex flex-col md:flex-row items-start md:items-end gap-3">
            <?php echo csrf_field(); ?>
            <div class="w-full md:w-64">
                <label class="block text-xs sm:text-sm text-gray-600 mb-1">Select Rider</label>
                <select name="rider_id" class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-indigo-500" required>
                    <option value="">-- choose rider --</option>
                    <?php $__currentLoopData = $riders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($r->id); ?>"><?php echo e($r->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <input type="hidden" name="parcel_ids[]" value="" />
            <button type="button" id="btnAssign" class="bg-green-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-green-700 transition">Assign Selected</button>
        </form>

        
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-3 py-2"><input type="checkbox" id="chkAll"></th>
                        <th class="px-6 py-2 text-left text-xs font-medium text-gray-500 uppercase">Tracking</th>
                        <th class="px-6 py-2 text-left text-xs font-medium text-gray-500 uppercase">Recipient</th>
                        <th class="px-6 py-2 text-left text-xs font-medium text-gray-500 uppercase">City / Zone</th>
                        <th class="px-6 py-2 text-left text-xs font-medium text-gray-500 uppercase">COD</th>
                        <th class="px-6 py-2 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                        <th class="px-6 py-2 text-left text-xs font-medium text-gray-500 uppercase">Assigned Rider</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__empty_1 = true; $__currentLoopData = $parcels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td class="px-3 py-2"><input type="checkbox" class="chkRow" value="<?php echo e($p->id); ?>"></td>
                            <td class="px-6 py-2 font-mono text-sm"><?php echo e($p->tracking_id); ?></td>
                            <td class="px-6 py-2">
                                <div class="text-sm text-gray-900"><?php echo e($p->recipient_name); ?></div>
                                <div class="text-xs text-gray-500"><?php echo e($p->address); ?></div>
                            </td>
                            <td class="px-6 py-2"><?php echo e($p->city); ?> / <?php echo e($p->zone); ?></td>
                            <td class="px-6 py-2"><?php echo e(number_format((float)$p->cod_amount, 2)); ?></td>
                            <td class="px-6 py-2"><?php echo e($p->status); ?></td>
                            <td class="px-6 py-2"><?php echo e(optional($p->rider)->name ?? '-'); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="px-6 py-6 text-center text-gray-500">No parcels found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    const chkAll = document.getElementById('chkAll');
    const rowChecks = Array.from(document.querySelectorAll('.chkRow'));
    chkAll?.addEventListener('change', () => {
        rowChecks.forEach(c => c.checked = chkAll.checked);
    });

    function collectSelectedIds() {
        return rowChecks.filter(c => c.checked).map(c => c.value);
    }

    // Assign
    document.getElementById('btnAssign')?.addEventListener('click', () => {
        const ids = collectSelectedIds();
        if (ids.length === 0) { alert('Select at least one parcel'); return; }
        const form = document.getElementById('assignForm');
        // clear old
        Array.from(form.querySelectorAll('input[name="parcel_ids[]"]')).forEach(n => n.remove());
        ids.forEach(id => {
            const h = document.createElement('input');
            h.type = 'hidden'; h.name = 'parcel_ids[]'; h.value = id; form.appendChild(h);
        });
        form.submit();
    });

    // Manifest
    document.getElementById('btnManifest')?.addEventListener('click', () => {
        const ids = collectSelectedIds();
        if (ids.length === 0) { alert('Select at least one parcel'); return; }
        const form = document.getElementById('manifestForm');
        Array.from(form.querySelectorAll('input[name="parcel_ids[]"]')).forEach(n => n.remove());
        ids.forEach(id => {
            const h = document.createElement('input');
            h.type = 'hidden'; h.name = 'parcel_ids[]'; h.value = id; form.appendChild(h);
        });
        form.submit();
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/admin/branch/dispatch.blade.php ENDPATH**/ ?>