

<?php $__env->startSection('title', 'Pending Settlement Report'); ?>

<?php $__env->startPush('styles'); ?>
<style>
    body { background: #f8f9fa; }
    .page-container { max-width: 1400px; margin: 0 auto; padding: 30px 20px; }
    .page-header { margin-bottom: 30px; }
    .page-title { font-size: 24px; font-weight: 600; color: #1a1a1a; margin-bottom: 8px; }
    .page-subtitle { font-size: 14px; color: #6b7280; }
    
    .stats-grid { display: grid; grid-template-columns: repeat(4, 1fr); gap: 20px; margin-bottom: 30px; }
    .stat-card { background: white; border-radius: 12px; padding: 20px; border: 1px solid #e5e7eb; }
    .stat-label { font-size: 13px; color: #6b7280; margin-bottom: 8px; }
    .stat-value { font-size: 28px; font-weight: 700; color: #1a1a1a; }
    .stat-value.danger { color: #ef4444; }
    
    .section-card { background: white; border-radius: 12px; border: 1px solid #e5e7eb; padding: 24px; margin-bottom: 24px; }
    .section-title { font-size: 18px; font-weight: 600; color: #1a1a1a; margin-bottom: 20px; }
    
    .data-table { width: 100%; border-collapse: collapse; }
    .data-table thead th { background: #f9fafb; padding: 12px 16px; text-align: left; font-size: 12px; font-weight: 600; color: #6b7280; text-transform: uppercase; border-bottom: 1px solid #e5e7eb; }
    .data-table tbody td { padding: 16px; border-bottom: 1px solid #f3f4f6; font-size: 14px; }
    .data-table tbody tr:hover { background: #f9fafb; }
    
    .badge { padding: 4px 12px; border-radius: 12px; font-size: 12px; font-weight: 600; }
    .badge-overdue { background: #fee2e2; color: #991b1b; }
    .badge-pending { background: #fef3c7; color: #92400e; }
    
    .action-link { color: #3b82f6; text-decoration: none; font-weight: 500; }
    .action-link:hover { text-decoration: underline; }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="page-container">
    <div class="page-header">
        <h1 class="page-title">Pending Settlement Report</h1>
        <p class="page-subtitle">Overview of all pending invoices and payments</p>
    </div>

    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-label">Pending Invoices</div>
            <div class="stat-value danger">Rs. <?php echo e(number_format($stats['total_pending_invoices'], 2)); ?></div>
            <div style="font-size: 13px; color: #6b7280; margin-top: 8px;"><?php echo e($stats['pending_count']); ?> invoices</div>
        </div>
        <div class="stat-card">
            <div class="stat-label">Pending Payments</div>
            <div class="stat-value danger">Rs. <?php echo e(number_format($stats['total_pending_payments'], 2)); ?></div>
            <div style="font-size: 13px; color: #6b7280; margin-top: 8px;">Awaiting processing</div>
        </div>
        <div class="stat-card">
            <div class="stat-label">Overdue Invoices</div>
            <div class="stat-value" style="color: #f59e0b;"><?php echo e($stats['overdue_invoices']); ?></div>
            <div style="font-size: 13px; color: #6b7280; margin-top: 8px;">Past due date</div>
        </div>
        <div class="stat-card">
            <div class="stat-label">Total Outstanding</div>
            <div class="stat-value danger">Rs. <?php echo e(number_format($stats['total_pending_invoices'] + $stats['total_pending_payments'], 2)); ?></div>
            <div style="font-size: 13px; color: #6b7280; margin-top: 8px;">Combined total</div>
        </div>
    </div>

    <!-- Pending Invoices -->
    <div class="section-card">
        <div class="section-title">Pending Invoices</div>
        <table class="data-table">
            <thead>
                <tr>
                    <th>Invoice #</th>
                    <th>Merchant</th>
                    <th>Amount</th>
                    <th>Invoice Date</th>
                    <th>Due Date</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $pendingInvoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><strong><?php echo e($invoice->invoice_number); ?></strong></td>
                    <td><?php echo e($invoice->merchant->name ?? 'N/A'); ?></td>
                    <td><strong>Rs. <?php echo e(number_format($invoice->total_amount, 2)); ?></strong></td>
                    <td><?php echo e($invoice->invoice_date->format('M d, Y')); ?></td>
                    <td><?php echo e($invoice->due_date->format('M d, Y')); ?></td>
                    <td>
                        <?php if($invoice->status == 'overdue'): ?>
                            <span class="badge badge-overdue">Overdue</span>
                        <?php else: ?>
                            <span class="badge badge-pending"><?php echo e(ucfirst($invoice->status)); ?></span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <a href="<?php echo e(url('finance/settlements.invoices.show', $invoice)); ?>" class="action-link">View Details</a>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="7" style="text-align: center; padding: 40px; color: #9ca3af;">
                        <i class="fas fa-check-circle" style="font-size: 48px; color: #10b981; margin-bottom: 16px; display: block;"></i>
                        No pending invoices
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <!-- Pending Payments -->
    <div class="section-card">
        <div class="section-title">Pending Payments</div>
        <table class="data-table">
            <thead>
                <tr>
                    <th>Payment #</th>
                    <th>Merchant</th>
                    <th>Amount</th>
                    <th>Payment Date</th>
                    <th>Method</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $pendingPayments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><strong><?php echo e($payment->payment_number); ?></strong></td>
                    <td><?php echo e($payment->merchant->name ?? 'N/A'); ?></td>
                    <td><strong>Rs. <?php echo e(number_format($payment->amount, 2)); ?></strong></td>
                    <td><?php echo e($payment->payment_date->format('M d, Y')); ?></td>
                    <td><?php echo e(ucfirst(str_replace('_', ' ', $payment->payment_method))); ?></td>
                    <td><span class="badge badge-pending">Pending</span></td>
                    <td>
                        <a href="<?php echo e(url('finance/settlements.payments.show', $payment)); ?>" class="action-link">View Details</a>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="7" style="text-align: center; padding: 40px; color: #9ca3af;">
                        <i class="fas fa-check-circle" style="font-size: 48px; color: #10b981; margin-bottom: 16px; display: block;"></i>
                        No pending payments
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/admin/finance/settlements/pending-report.blade.php ENDPATH**/ ?>