

<?php $__env->startSection('title', 'Pickup Report'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-8">
    <h1 class="text-2xl font-bold">Pick up Report</h1>
    <div class="bg-white rounded-lg shadow-md">
        <div class="p-4 border-b">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div class="flex items-center gap-2 border-b flex-wrap">
                    <button class="py-2 px-3 border-b-2 border-blue-500 text-blue-600 text-xs h-8">All (0)</button>
                    <button class="py-2 px-3 border-b-2 border-transparent text-gray-500 hover:text-gray-700 text-xs h-8">InTransit (0)</button>
                    <button class="py-2 px-3 border-b-2 border-transparent text-gray-500 hover:text-gray-700 text-xs h-8">Delivered (0)</button>
                    <button class="py-2 px-3 border-b-2 border-transparent text-gray-500 hover:text-gray-700 text-xs h-8">Return In-Transit (0)</button>
                    <button class="py-2 px-3 border-b-2 border-transparent text-gray-500 hover:text-gray-700 text-xs h-8">Returned (0)</button>
                </div>
                <div class="flex items-center gap-2">
                    <button class="bg-gray-200 text-gray-700 p-2 rounded-md"><i class="fas fa-sync-alt"></i></button>
                    <button class="bg-gray-200 text-gray-700 p-2 rounded-md"><i class="fas fa-layer-group"></i></button>
                    <button class="bg-gray-200 text-gray-700 p-2 rounded-md"><i class="fas fa-download"></i></button>
                    <button class="bg-gray-200 text-gray-700 p-2 rounded-md"><i class="fas fa-cog"></i></button>
                </div>
            </div>
        </div>
        <div class="p-6 space-y-6">
            <div class="p-4 border rounded-lg bg-gray-50">
                <p class="text-sm font-semibold mb-4 text-gray-500">ADVANCED SEARCH</p>
                <form action="<?php echo e(route('seller.reports.pickup')); ?>" method="GET" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 items-end">
                    <div class="lg:col-span-2">
                        <label class="text-xs text-gray-500">Search by</label>
                        <div class="flex">
                            <input type="text" name="search" value="<?php echo e(request('search')); ?>" placeholder="Search..." class="w-full border-gray-300 rounded-l-md shadow-sm">
                            <select name="search_type" class="w-auto min-w-[160px] border-gray-300 rounded-r-md shadow-sm border-l-0">
                                <option value="tracking_id" <?php if(request('search_type') == 'tracking_id'): echo 'selected'; endif; ?>>TRACKING #</option>
                                <option value="recipient_name" <?php if(request('search_type') == 'recipient_name'): echo 'selected'; endif; ?>>NAME</option>
                            </select>
                        </div>
                    </div>
                    <div>
                        <label class="text-xs text-gray-500">FROM</label>
                        <input type="date" name="from_date" value="<?php echo e(request('from_date')); ?>" class="w-full border-gray-300 rounded-md shadow-sm">
                    </div>
                    <div>
                        <label class="text-xs text-gray-500">TO</label>
                        <input type="date" name="to_date" value="<?php echo e(request('to_date')); ?>" class="w-full border-gray-300 rounded-md shadow-sm">
                    </div>
                    <div class="flex items-end gap-2 col-start-1">
                        <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-md font-semibold">Search</button>
                        <a href="<?php echo e(route('seller.reports.pickup')); ?>" class="bg-gray-200 text-gray-700 px-4 py-2 rounded-md font-semibold text-center">Clear Filter</a>
                    </div>
                </form>
            </div>

            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead>
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Pickup Date</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Order Ref</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Tracking #</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Customer</th>
                            <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Amount</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo e($order->created_at->format('d M, Y')); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo e($order->order_ref ?? 'N/A'); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-blue-600"><?php echo e($order->tracking_id); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo e($order->recipient_name); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900 text-right">PKR <?php echo e(number_format($order->cod_amount, 2)); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm">
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-blue-100 text-blue-800"><?php echo e($order->status); ?></span>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="text-center py-10 text-sm text-gray-500">No data to display.</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
                <div class="mt-4">
                    <?php echo e($orders->appends(request()->query())->links()); ?>

                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.seller', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/seller/reports/pickup.blade.php ENDPATH**/ ?>