

<?php $__env->startSection('title', 'Deductions'); ?>

<?php $__env->startPush('styles'); ?>
<style>
    body { background: #f8f9fa; }
    .page-container { max-width: 1400px; margin: 0 auto; padding: 30px 20px; }
    .page-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 30px; }
    .page-title { font-size: 24px; font-weight: 600; color: #1a1a1a; }
    .btn-primary { background: #3b82f6; color: white; border: none; padding: 10px 20px; border-radius: 6px; font-size: 14px; font-weight: 600; cursor: pointer; }
    .btn-primary:hover { background: #2563eb; transform: translateY(-1px); }
    
    .stats-grid { display: grid; grid-template-columns: repeat(4, 1fr); gap: 20px; margin-bottom: 30px; }
    .stat-card { background: white; border-radius: 12px; padding: 20px; border: 1px solid #e5e7eb; }
    .stat-label { font-size: 13px; color: #6b7280; margin-bottom: 8px; }
    .stat-value { font-size: 28px; font-weight: 700; color: #1a1a1a; }
    
    .table-card { background: white; border-radius: 12px; border: 1px solid #e5e7eb; overflow: hidden; }
    .table-header { padding: 20px; border-bottom: 1px solid #e5e7eb; }
    .data-table { width: 100%; border-collapse: collapse; }
    .data-table thead th { background: #f9fafb; padding: 12px 20px; text-align: left; font-size: 12px; font-weight: 600; color: #6b7280; text-transform: uppercase; }
    .data-table tbody td { padding: 16px 20px; border-bottom: 1px solid #f3f4f6; font-size: 14px; }
    .data-table tbody tr:hover { background: #f9fafb; }
    
    .badge { padding: 4px 12px; border-radius: 12px; font-size: 12px; font-weight: 600; }
    .badge-pending { background: #fef3c7; color: #92400e; }
    .badge-approved { background: #d1fae5; color: #065f46; }
    .badge-rejected { background: #fee2e2; color: #991b1b; }
    .badge-applied { background: #dbeafe; color: #1e40af; }
    
    .action-btn { background: none; border: none; color: #3b82f6; cursor: pointer; padding: 4px 8px; font-size: 14px; }
    .action-btn:hover { color: #2563eb; text-decoration: underline; }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="page-container">
    <div class="page-header">
        <h1 class="page-title">Merchant Deductions</h1>
<a href="<?php echo e(route('finance.settlements.deductions.create')); ?>" class="btn-primary">
            <i class="fas fa-plus me-2"></i>New Deduction
        </a>
    </div>

    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-label">Total Pending</div>
            <div class="stat-value">Rs. <?php echo e(number_format($stats['total_pending'], 2)); ?></div>
        </div>
        <div class="stat-card">
            <div class="stat-label">Total Approved</div>
            <div class="stat-value">Rs. <?php echo e(number_format($stats['total_approved'], 2)); ?></div>
        </div>
        <div class="stat-card">
            <div class="stat-label">Total Applied</div>
            <div class="stat-value">Rs. <?php echo e(number_format($stats['total_applied'], 2)); ?></div>
        </div>
        <div class="stat-card">
            <div class="stat-label">Pending Count</div>
            <div class="stat-value"><?php echo e($stats['count_pending']); ?></div>
        </div>
    </div>

    <div class="table-card">
        <div class="table-header flex justify-between items-center">
            <h3 class="text-lg font-semibold">All Deductions</h3>
<form method="GET" action="<?php echo e(route('finance.settlements.deductions.index')); ?>" class="flex items-center space-x-2">
                <input type="date" name="start_date" class="form-input" value="<?php echo e(request('start_date')); ?>">
                <input type="date" name="end_date" class="form-input" value="<?php echo e(request('end_date')); ?>">
                <button type="submit" class="btn-primary">Filter</button>
            </form>
        </div>
        
        <table class="data-table">
            <thead>
                <tr>
                    <th>Deduction #</th>
                    <th>Merchant</th>
                    <th>Type</th>
                    <th>Amount</th>
                    <th>Date</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $deductions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deduction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><strong><?php echo e($deduction->deduction_number); ?></strong></td>
                    <td><?php echo e($deduction->merchant->name ?? 'N/A'); ?></td>
                    <td><?php echo e(ucfirst(str_replace('_', ' ', $deduction->deduction_type))); ?></td>
                    <td><strong>Rs. <?php echo e(number_format($deduction->amount, 2)); ?></strong></td>
                    <td><?php echo e($deduction->deduction_date->format('M d, Y')); ?></td>
                    <td>
                        <?php if($deduction->status == 'pending'): ?>
                            <span class="badge badge-pending">Pending</span>
                        <?php elseif($deduction->status == 'approved'): ?>
                            <span class="badge badge-approved">Approved</span>
                        <?php elseif($deduction->status == 'rejected'): ?>
                            <span class="badge badge-rejected">Rejected</span>
                        <?php else: ?>
                            <span class="badge badge-applied">Applied</span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <a href="<?php echo e(route('finance.settlements.deductions.show', $deduction)); ?>" class="action-btn">View</a>
                        <?php if($deduction->status == 'pending'): ?>
<form action="<?php echo e(route('finance.settlements.deductions.approve', $deduction)); ?>" method="POST" style="display: inline;">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="action-btn" style="color: #10b981;">Approve</button>
                        </form>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="7" style="text-align: center; padding: 40px; color: #9ca3af;">
                        <i class="fas fa-inbox" style="font-size: 48px; margin-bottom: 16px; display: block;"></i>
                        No deductions found
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
        
        <?php if($deductions->hasPages()): ?>
        <div style="padding: 20px; border-top: 1px solid #e5e7eb;">
            <?php echo e($deductions->links()); ?>

        </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/admin/finance/settlements/deductions/index.blade.php ENDPATH**/ ?>