<aside id="sidebar" class="w-56 bg-white border-r border-gray-200 min-h-screen fixed left-0 top-16 bottom-0 overflow-y-auto z-20" x-data="{ open: '' }">
    <nav class="py-2">
        <?php
            $branchMenuGroups = [
                [
                    'title' => 'OVERVIEW',
                    'items' => [
                        ['href' => 'admin.branch.dashboard', 'label' => 'Dashboard', 'icon' => 'fa-home'],
                    ]
                ],
                [
                    'title' => 'Shipments & Operations',
                    'items' => [
                        ['href' => 'admin.branch.bagging', 'label' => 'Bagging', 'icon' => 'fa-archive'],
                        ['href' => 'admin.branch.unbagging', 'label' => 'Unbagging', 'icon' => 'fa-box-open'],
                        ['href' => 'admin.branch.pickup-orders', 'label' => 'Pickup Orders', 'icon' => 'fa-box-check'],
                        ['href' => 'admin.branch.receive-shipments', 'label' => 'Receive Shipments', 'icon' => 'fa-scanner-gun'],
                        ['href' => 'admin.branch.dispatch-shipments', 'label' => 'Dispatch Shipments', 'icon' => 'fa-upload'],
                        ['href' => '#', 'label' => 'Carrier Manifest', 'icon' => 'fa-file-chart-line'],
                        ['href' => 'admin.branch.deliveries-assigned', 'label' => 'Deliveries Assigned', 'icon' => 'fa-user-check'],
                        ['href' => 'admin.branch.successful-deliveries', 'label' => 'Successful Deliveries', 'icon' => 'fa-thumbs-up'],
                        ['href' => 'admin.branch.failed-deliveries', 'label' => 'Failed Deliveries', 'icon' => 'fa-thumbs-down'],
                        ['href' => 'admin.branch.reattempt-shipment', 'label' => 'Reattempt Shipment', 'icon' => 'fa-clipboard-check'],
                        ['href' => 'admin.branch.return-shipments', 'label' => 'Return Shipments (RTO)', 'icon' => 'fa-sync-alt'],
                        ['href' => 'admin.branch.forward-to-origin', 'label' => 'Forward to Origin / Hub', 'icon' => 'fa-exchange-alt'],
                        ['href' => 'admin.branch.shipment-tracking', 'label' => 'Shipment Tracking', 'icon' => 'fa-search-location'],
                        ['href' => 'admin.branch.search-bag', 'label' => 'Search Bag', 'icon' => 'fa-fingerprint'],
                        ['href' => 'admin.branch.lost-hold', 'label' => 'Lost / Hold', 'icon' => 'fa-exclamation-triangle'],
                    ]
                ],
                [
                    'title' => 'Rider Management',
                    'items' => [
                        ['href' => 'admin.branch.riders.onboarding', 'label' => 'Onboarding', 'icon' => 'fa-user-plus'],
                        ['href' => 'admin.branch.riders.daily-load', 'label' => 'Rider Daily Load', 'icon' => 'fa-clipboard-list'],
                        ['href' => 'admin.branch.riders.cod-assigned', 'label' => 'COD Value Assigned', 'icon' => 'fa-dollar-sign'],
                    ]
                ],
                [
                    'title' => 'Staff Management',
                    'items' => [
                        ['href' => '#', 'label' => 'Manage Staff', 'icon' => 'fa-users'],
                        ['href' => '#', 'label' => 'Staff Salary', 'icon' => 'fa-hand-holding-usd'],
                        ['href' => '#', 'label' => 'Attendance', 'icon' => 'fa-clock'],
                    ]
                ],
                [
                    'title' => 'Finance & Cash Flow',
                    'items' => [
                        ['href' => 'admin.branch.finance.rider-handover', 'label' => 'Rider Handover', 'icon' => 'fa-wallet'],
                        ['href' => 'admin.branch.finance.pending-cod', 'label' => 'Pending COD', 'icon' => 'fa-hourglass-half'],
                        ['href' => 'admin.branch.finance.variance-report', 'label' => 'Variance Report', 'icon' => 'fa-chart-bar'],
                    ]
                ],
                [
                    'title' => 'Cashier Module',
                    'items' => [
                        ['href' => 'admin.branch.cashier.collect-cod', 'label' => 'Collect COD', 'icon' => 'fa-circle-dollar-to-slot'],
                        ['href' => '#', 'label' => 'Mark Deposited', 'icon' => 'fa-money-check-alt'],
                        ['href' => '#', 'label' => 'Cash in Transit', 'icon' => 'fa-layer-group'],
                    ]
                ],
                 [
                    'title' => 'Complaints & Support',
                    'items' => [
                        ['href' => 'admin.complaints.index', 'label' => 'Register Complaint', 'icon' => 'fa-comment-alt-exclamation'],
                    ]
                ],
                 [
                    'title' => 'Reports & Analytics',
                    'items' => [
                        ['href' => '#', 'label' => 'Shipment Reports', 'icon' => 'fa-chart-line'],
                    ]
                ],
                 [
                    'title' => 'System & Security',
                    'items' => [
                        ['href' => '#', 'label' => 'Sync Status', 'icon' => 'fa-history'],
                        ['href' => '#', 'label' => 'Audit Trail', 'icon' => 'fa-file-clock'],
                        ['href' => '#', 'label' => 'Activity Log', 'icon' => 'fa-history'],
                    ]
                ],
            ];
        ?>

        <?php $__currentLoopData = $branchMenuGroups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="mb-1">
                <h3 class="px-3 py-2 font-semibold text-primary uppercase text-xs tracking-wider"><?php echo e($group['title']); ?></h3>
                <div class="flex flex-col gap-1">
                    <?php $__currentLoopData = $group['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a href="<?php echo e($item['href'] === '#' ? '#' : route($item['href'])); ?>" 
                           class="flex items-center px-3 py-1.5 text-sm text-gray-700 hover:bg-blue-50 <?php echo e(request()->routeIs($item['href']) ? 'bg-blue-50 text-blue-600 font-bold border-r-4 border-blue-600' : ''); ?>">
                            <i class="fas <?php echo e($item['icon']); ?> w-5 h-5 mr-3"></i>
                            <span><?php echo e($item['label']); ?></span>
                        </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </nav>
</aside>
<?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/partials/branch-sidebar.blade.php ENDPATH**/ ?>