

<?php $__env->startSection('title', 'Document Templates'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-6 flex items-center justify-between">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Document Templates</h1>
            <p class="text-xs sm:text-sm text-gray-600 mt-1">List of all templates</p>
        </div>
        <a href="<?php echo e(route('admin.marketing.documents.templates.create')); ?>" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">New Template</a>
    </div>

    <?php if(session('success')): ?>
        <div class="mb-4 p-3 bg-green-100 text-green-700 rounded"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <div class="bg-white rounded-lg shadow-md">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Title</th>
                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Code</th>
                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Category</th>
                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-500 uppercase">Version</th>
                    <th class="px-4 py-2 text-right text-xs font-medium text-gray-500 uppercase">Actions</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php $__empty_1 = true; $__currentLoopData = $templates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $template): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td class="px-4 py-2"><?php echo e($template->title); ?></td>
                    <td class="px-4 py-2"><?php echo e($template->code); ?></td>
                    <td class="px-4 py-2"><?php echo e($template->category); ?></td>
                    <td class="px-4 py-2">
                        <span class="px-2 py-1 text-xs rounded bg-gray-100"><?php echo e(ucfirst($template->status)); ?></span>
                    </td>
                    <td class="px-4 py-2"><?php echo e($template->version); ?></td>
                    <td class="px-4 py-2 text-right space-x-2">
                        <a href="<?php echo e(route('admin.marketing.documents.templates.show', $template)); ?>" class="text-blue-600 hover:underline">View</a>
                        <a href="<?php echo e(route('admin.marketing.documents.templates.edit', $template)); ?>" class="text-indigo-600 hover:underline">Edit</a>
                        <form action="<?php echo e(route('admin.marketing.documents.templates.destroy', $template)); ?>" method="POST" class="inline">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="text-red-600 hover:underline" onclick="return confirm('Delete this template?')">Delete</button>
                        </form>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="6" class="px-4 py-8 text-center text-gray-500">No templates found.</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
        <div class="p-4"><?php echo e($templates->links()); ?></div>
    </div>
    <div class="mt-4">
        <a href="<?php echo e(route('admin.marketing.documents.index')); ?>" class="text-gray-600 hover:text-gray-800">← Back to Documents</a>
    </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/admin/marketing/documents/templates/index.blade.php ENDPATH**/ ?>