<?php $__env->startSection('title', 'Payroll Run'); ?>

<?php $__env->startSection('content'); ?>
<div class="p-6 lg:p-8">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Payroll Run</h1>
            <p class="text-sm text-gray-600">Process payroll for selected month and employees.</p>
        </div>
        <form method="POST" action="<?php echo e(route('finance.payroll.payroll-run.process')); ?>" class="flex items-center space-x-2">
            <?php echo csrf_field(); ?>
            <input type="month" name="month" value="<?php echo e(request('month', date('Y-m'))); ?>" class="form-input">
            <select name="employee_id" class="form-select">
                <option value="">All Employees</option>
                <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($employee->id); ?>"><?php echo e($employee->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
            <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Process Payroll</button>
        </form>
    </div>

    <div class="bg-white rounded-lg shadow-md p-6">
        <div class="text-center py-10">
            <h3 class="text-lg font-semibold">Ready to Process Payroll</h3>
            <p class="text-gray-600 mt-2">Select a month and optionally an employee, then submit to generate salary slips.</p>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/admin/finance/payroll/payroll-run.blade.php ENDPATH**/ ?>