

<?php $__env->startSection('title', 'Tax Calendar Alerts'); ?>

<?php $__env->startSection('content'); ?>
<div class="p-6 lg:p-8" x-data="{ showModal: false }" @open-modal.window="showModal = true">
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Tax Calendar Alerts</h1>
            <p class="text-sm text-gray-600">Manage important tax deadlines and alerts.</p>
        </div>
        <button @click="showModal = true" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Add New Alert</button>
    </div>

    <!-- Alerts Table -->
    <div class="bg-white rounded-lg shadow-md">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Title</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Alert Date</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Frequency</th>
                        <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase">Status</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__empty_1 = true; $__currentLoopData = $alerts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $alert): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td class="px-6 py-4"><?php echo e($alert->title); ?></td>
                            <td class="px-6 py-4"><?php echo e($alert->alert_date->format('M d, Y')); ?></td>
                            <td class="px-6 py-4"><?php echo e(ucfirst($alert->frequency)); ?></td>
                            <td class="px-6 py-4 text-center"><span class="px-2 py-1 text-xs rounded-full <?php echo e($alert->is_active ? 'bg-green-100 text-green-800' : 'bg-gray-200'); ?>"><?php echo e($alert->is_active ? 'Active' : 'Inactive'); ?></span></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr><td colspan="4" class="text-center py-10">No tax alerts found.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Add Alert Modal -->
    <div x-show="showModal" @click.away="showModal = false" class="fixed inset-0 bg-gray-600 bg-opacity-50 h-full w-full z-50" x-cloak>
        <div class="relative top-10 mx-auto p-5 border w-full max-w-lg shadow-lg rounded-md bg-white">
            <form action="<?php echo e(route('finance.taxation.calendar-alerts.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <h3 class="text-lg font-semibold mb-4">Add New Tax Alert</h3>
                <div class="space-y-4">
                                        <div>
                        <label class="block text-sm">Title</label>
                        <input type="text" name="title" class="form-input" required>
                    </div>
                    <div>
                        <label class="block text-sm">Alert Date</label>
                        <input type="date" name="alert_date" class="form-input" required>
                    </div>
                    <div>
                        <label class="block text-sm">Frequency</label>
                        <select name="frequency" class="form-select">
                            <option value="">One-time</option>
                            <option value="monthly">Monthly</option>
                            <option value="quarterly">Quarterly</option>
                            <option value="annually">Annually</option>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm">Description</label>
                        <textarea name="description" rows="3" class="form-input"></textarea>
                    </div>
                </div>
                <div class="flex justify-end space-x-2 mt-6">
                    <button type="button" @click="showModal = false" class="bg-gray-300 text-gray-700 px-4 py-2 rounded-lg">Close</button>
                    <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Save Alert</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        <?php if($errors->any()): ?>
            window.dispatchEvent(new CustomEvent('open-modal'));
        <?php endif; ?>
    });
</script>
<?php $__env->stopPush(); ?>




<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/admin/finance/taxation/calendar-alerts.blade.php ENDPATH**/ ?>