

<?php $__env->startSection('title', 'Company Expenses'); ?>

<?php $__env->startSection('content'); ?>
<div class="p-6 lg:p-8" x-data="{ showModal: false }" @open-modal.window="showModal = true">
    <!-- Page Header -->
    <div class="flex justify-between items-center mb-6">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-800">Company Expenses</h1>
            <p class="text-sm text-gray-600">Track and manage all company-wide expenses.</p>
        </div>
        <button @click="showModal = true" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Add New Expense</button>
    </div>

    <!-- Filters -->
    <form method="GET" action="<?php echo e(route('finance.expenses.company')); ?>" class="bg-white rounded-lg shadow-md p-4 mb-6 grid grid-cols-1 md:grid-cols-4 gap-4">
        <input type="date" name="start_date" value="<?php echo e(request('start_date')); ?>" class="form-input">
        <input type="date" name="end_date" value="<?php echo e(request('end_date')); ?>" class="form-input">
        <select name="expense_category" class="form-select">
            <option value="">All Categories</option>
            <?php $__currentLoopData = ['office_supplies', 'utilities', 'rent', 'salary', 'marketing', 'travel', 'maintenance', 'other']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($cat); ?>" <?php echo e(request('expense_category') == $cat ? 'selected' : ''); ?>><?php echo e(ucwords(str_replace('_', ' ', $cat))); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
        <button type="submit" class="bg-gray-800 text-white px-4 py-2 rounded-md">Filter</button>
    </form>

    <!-- Expenses Table -->
    <div class="bg-white rounded-lg shadow-md">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Date</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Title</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Category</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Amount</th>
                        <th class="px-6 py-3 text-center text-xs font-medium text-gray-500 uppercase">Status</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__empty_1 = true; $__currentLoopData = $expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs"><?php echo e($expense->expense_date->format('M d, Y')); ?></td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs font-medium"><?php echo e($expense->title); ?></td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs"><?php echo e(ucwords(str_replace('_', ' ', $expense->expense_category))); ?></td>
                            <td class="px-6 py-4 text-right text-sm"><?php echo e(number_format($expense->amount, 2)); ?></td>
                            <td class="px-6 py-4 text-center text-sm">
                                <?php
                                    $statusColor = match($expense->status) {
                                        'approved' => ['bg' => 'bg-green-100', 'text' => 'text-green-800'],
                                        'paid' => ['bg' => 'bg-blue-100', 'text' => 'text-blue-800'],
                                        'rejected' => ['bg' => 'bg-red-100', 'text' => 'text-red-800'],
                                        default => ['bg' => 'bg-yellow-100', 'text' => 'text-yellow-800']
                                    };
                                ?>
                                <span class="px-2 inline-flex text-[10px] leading-4 font-semibold rounded-full <?php echo e($statusColor['bg']); ?> <?php echo e($statusColor['text']); ?>">
                                    <?php echo e(ucfirst($expense->status)); ?>

                                </span>
                            </td>
                            <td class="px-6 py-4 text-right text-sm font-medium">
                                <a href="<?php echo e(route('finance.expenses.edit', $expense)); ?>" class="text-indigo-600 hover:text-indigo-900 mr-3">Edit</a>
                                <form action="<?php echo e(route('finance.expenses.destroy', $expense)); ?>" method="POST" class="inline" onsubmit="return confirm('Are you sure you want to delete this expense?')">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="text-red-600 hover:text-red-900">Delete</button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="text-center py-10 text-gray-500">No expenses found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <div class="p-4 border-t">
            <?php echo e($expenses->links()); ?>

        </div>
    </div>

    <!-- Add Expense Modal -->
    <div x-show="showModal" @keydown.escape.window="showModal = false" @click.away="showModal = false" class="fixed inset-0 bg-gray-600 bg-opacity-50 h-full w-full z-50" x-cloak>
        <div class="relative top-10 mx-auto p-5 border w-full max-w-xl shadow-xl rounded-lg bg-white" role="dialog" aria-modal="true" aria-labelledby="add-expense-title">
            <form action="<?php echo e(route('finance.expenses.store')); ?>" method="POST" enctype="multipart/form-data" novalidate>
                <?php echo csrf_field(); ?>
                <h3 id="add-expense-title" class="text-lg font-semibold mb-4">Add New Expense</h3>
                <?php if($errors->any()): ?>
                    <div class="mb-4 rounded-md bg-red-50 p-3">
                        <div class="text-red-700 text-sm font-semibold mb-1">Please fix the following:</div>
                        <ul class="list-disc list-inside text-xs text-red-700">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>
                <div class="space-y-4">
                    <div>
                        <label for="title" class="block text-xs sm:text-sm font-medium text-gray-700">Title</label>
                        <input id="title" type="text" name="title" value="<?php echo e(old('title')); ?>" class="mt-1 form-input placeholder-gray-400" placeholder="e.g., Printer ink" autocomplete="off" autofocus required>
                    </div>
                    <div>
                        <label for="expense_category" class="block text-xs sm:text-sm font-medium text-gray-700">Category</label>
                        <select id="expense_category" name="expense_category" class="mt-1 form-select" required>
                            <?php $__currentLoopData = ['office_supplies', 'utilities', 'rent', 'salary', 'marketing', 'travel', 'maintenance', 'other']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($cat); ?>"><?php echo e(ucwords(str_replace('_', ' ', $cat))); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div>
                        <label for="amount" class="block text-xs sm:text-sm font-medium text-gray-700">Amount</label>
                        <input id="amount" type="number" inputmode="decimal" name="amount" value="<?php echo e(old('amount')); ?>" step="0.01" class="mt-1 form-input placeholder-gray-400" placeholder="e.g., 1200" required>
                    </div>
                    <div>
                        <label for="expense_date" class="block text-xs sm:text-sm font-medium text-gray-700">Expense Date</label>
                        <input id="expense_date" type="date" name="expense_date" value="<?php echo e(old('expense_date', now()->format('Y-m-d'))); ?>" class="mt-1 form-input" required>
                    </div>
                    <div>
                        <label for="description" class="block text-xs sm:text-sm font-medium text-gray-700">Description</label>
                        <textarea id="description" name="description" rows="3" class="mt-1 form-input placeholder-gray-400" placeholder="Optional notes"><?php echo e(old('description')); ?></textarea>
                    </div>
                    <div>
                        <label for="receipt" class="block text-xs sm:text-sm font-medium text-gray-700">Receipt (optional)</label>
                        <input id="receipt" type="file" name="receipt" class="mt-1 form-input" accept="image/*,.pdf">
                        <p class="mt-1 text-[11px] text-gray-500">Accepted: images or PDF. Max size 5MB.</p>
                    </div>
                </div>
                <div class="flex justify-end space-x-2 mt-6">
                    <button type="button" @click="showModal = false" class="bg-gray-300 text-gray-700 px-4 py-2 rounded-lg hover:bg-gray-400">Close</button>
                    <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Save Expense</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    [x-cloak] { display: none !important; }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        <?php if($errors->any()): ?>
            window.dispatchEvent(new CustomEvent('open-modal'));
        <?php endif; ?>
    });
</script>
<?php $__env->stopPush(); ?>




<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/admin/finance/expense/company.blade.php ENDPATH**/ ?>