

<?php $__env->startSection('title', 'Vehicle Dispatch'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-6 flex justify-between items-center">
        <div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Vehicle Dispatch</h1>
            <p class="text-xs sm:text-sm text-gray-600 mt-1">Monitor and manage vehicle dispatches.</p>
        </div>
        <div>
            <a href="#" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Create New Dispatch</a>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Vehicle</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Driver</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Route</th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th class="relative px-6 py-3">
                            <span class="sr-only">Actions</span>
                        </th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__currentLoopData = $dispatches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dispatch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs font-medium text-gray-900"><?php echo e($dispatch['vehicle']); ?></td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-500"><?php echo e($dispatch['driver']); ?></td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-500"><?php echo e($dispatch['route']); ?></td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs">
                                <span class="px-2 inline-flex text-[10px] leading-4 font-semibold rounded-full 
                                    <?php switch($dispatch['status']):
                                        case ('In-transit'): ?> bg-blue-100 text-blue-800 <?php break; ?>
                                        <?php case ('Pending'): ?> bg-yellow-100 text-yellow-800 <?php break; ?>
                                        <?php case ('Delivered'): ?> bg-green-100 text-green-800 <?php break; ?>
                                    <?php endswitch; ?>">
                                    <?php echo e($dispatch['status']); ?>

                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                <a href="#" class="text-indigo-600 hover:text-indigo-900">View Details</a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/admin/logistics/vehicle/dispatch.blade.php ENDPATH**/ ?>